% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LRcell.R
\name{LRcell}
\alias{LRcell}
\title{Cell-type enrichment analysis for preranked gene set.}
\usage{
LRcell(
  gene.p,
  marker.g = NULL,
  species = c("mouse", "human"),
  region = NULL,
  method = c("LR", "LiR"),
  min.size = 5,
  sig.cutoff = 0.05
)
}
\arguments{
\item{gene.p}{Named vector of gene-level pvalues from DEG analysis, i.e.
DESeq2, LIMMA}

\item{marker.g}{List of Cell-type specific marker genes derived from
single-cell RNA-seq. The name of the list is cell-type or cluster name, the
values are marker genes vectors or numeric named vectors. LRcell provides
marker genes list in different human/mouse brains, but users could use their
own marker gene list as input.
default: NULL}

\item{species}{Either `mouse` or `human`, default: mouse.}

\item{region}{Specific brain regions provided by LRcell. For mouse, LRcell
provides 9 brain regions: c("FC", "HC", "PC", "GP", "STR", "TH", "SN", "ENT",
"CB"). For human, LRcell provides c("pFC", "PBMC")}

\item{method}{Either `logistic regression` or `linear regression`. Logistic
regression equally treats cell-type specific marker genes, however, if
certain values could determine the importance of marker genes, linear
regression can be performed, default: LR.}

\item{min.size}{Minimal size of a marker gene set, will impact the balance of
labels}

\item{sig.cutoff}{Cutoff for input genes pvalues, default: 0.05.}
}
\value{
A list with LRcell results. Each item represents a marker gene input.
Each item in this list is a statistics table. In the table, the row
represents the name of marker genes, and the columns are:
\itemize{
 \item ID The IDs of each marker genes, can be a cell type or cluster;
 \item genes_num How many marker genes are contributing to the analysis;
 \item coef The coefficients of Logistic Regression or Linear Regression;
 \item odds_ratio The odds ratio quantifies association in Logistic
 Regression;
 \item p-value The p-value calculated from the analysis;
 \item FDR The FDR after BH correction.
 \item lead_genes Genes that are contributing to the analysis;
}
}
\description{
This function wraps around \code{\link{LRcellCore}} in case of empty
inputs of the marker gene file and brain region.
}
\examples{
data(example_gene_pvals)
res <- LRcell(example_gene_pvals, species="mouse", region="FC", method="LR")
}
