% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_marker_dist}
\alias{plot_marker_dist}
\title{Plot marker genes distribution on DE gene rank}
\usage{
plot_marker_dist(markers, gene.p, colour = "red")
}
\arguments{
\item{markers}{Vector of marker genes from a cell type or cluster of interest.}

\item{gene.p}{Named vector of gene-level pvalues from DEG analysis, i.e.
DESeq2, LIMMA}

\item{colour}{Users can define the bar color they want on the ggplot2 object.}
}
\value{
A ggplot2 object
}
\description{
This function draws out the marker gene distribution for a certain cell type
(or cluster) on the DE gene rank list.
}
\examples{
data(example_gene_pvals)
data(mouse_FC_marker_genes)
Oligos_markers <- mouse_FC_marker_genes[["FC_9-5.Oligodendrocytes_5"]]
plot_marker_dist(Oligos_markers, example_gene_pvals)
}
