% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_Spectra_metrics.R
\name{rtAcquisitionRange}
\alias{rtAcquisitionRange}
\title{retention time acquisition range (MS:4000070)}
\usage{
rtAcquisitionRange(spectra, msLevel = 1L, ...)
}
\arguments{
\item{spectra}{\code{Spectra} object}

\item{msLevel}{\code{integer}}

\item{...}{not used here}
}
\value{
\code{numeric(2)}
}
\description{
MS:4000070 \cr
"Upper and lower limit of retention time at which spectra are recorded." 
[PSI:MS] \cr

The metric is calculated as follows: \cr
(1) the \code{Spectra} object is filtered according to the MS level, \cr 
(2) the retention time values of the features within the \code{Spectra} 
object are obtained, \cr 
(3) the minimum and maximum retention time values are obtained and 
returned. \cr
}
\details{
MS:4000070 \cr
is_a: MS:4000004 ! n-tuple \cr
relationship: has_metric_category MS:4000009 ! ID free metric \cr
relationship: has_metric_category MS:4000012 ! single run based metric \cr
relationship: has_metric_category MS:4000016 ! retention time metric \cr
relationship: has_units UO:0000010 ! second \cr
relationship: has_value_concept STATO:0000035 ! range \cr
}
\examples{
library(S4Vectors)
library(Spectra)

spd <- DataFrame(
    msLevel = c(2L, 2L, 2L),
    polarity = c(1L, 1L, 1L),
    id = c("HMDB0000001", "HMDB0000001", "HMDB0001847"),
    name = c("1-Methylhistidine", "1-Methylhistidine", "Caffeine"))
## Assign m/z and intensity values
spd$mz <- list(
    c(109.2, 124.2, 124.5, 170.16, 170.52),
    c(83.1, 96.12, 97.14, 109.14, 124.08, 125.1, 170.16),
    c(56.0494, 69.0447, 83.0603, 109.0395, 110.0712,
        111.0551, 123.0429, 138.0662, 195.0876))
spd$intensity <- list(
    c(3.407, 47.494, 3.094, 100.0, 13.240),
    c(6.685, 4.381, 3.022, 16.708, 100.0, 4.565, 40.643),
    c(0.459, 2.585, 2.446, 0.508, 8.968, 0.524, 0.974, 100.0, 40.994))
spd$rtime <- c(9.44, 9.44, 15.84)
sps <- Spectra(spd)
rtAcquisitionRange(spectra = sps, msLevel = 2L)
}
\author{
Thomas Naake
}
