% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_Spectra_metrics.R
\name{ticQuartersRtFraction}
\alias{ticQuartersRtFraction}
\title{TIC quarters RT fraction (MS:4000054)}
\usage{
ticQuartersRtFraction(
  spectra,
  probs = seq(0, 1, 0.25),
  msLevel = 1L,
  relative = TRUE,
  ...
)
}
\arguments{
\item{spectra}{\code{Spectra} object}

\item{probs}{\code{numeric} defining the quantiles. See \code{probs = seq(0, 1, 0.25)}.}

\item{msLevel}{\code{integer}}

\item{relative}{\code{logical}, if set to \code{TRUE} the relative retention time 
will be returned instead of the abolute retention time}

\item{...}{not used here}
}
\value{
\code{numeric} of length equal to length \code{probs} with the relative
   duration (duration divided by the total run time) after which the TIC
   exceeds the respective quantile of the TIC.
}
\description{
MS:4000054
"The interval when the respective quarter of the TIC accumulates divided by 
retention time duration." [PSI:MS] \cr

The metric is calculated as follows: \cr
(1) the \code{Spectra} object is ordered according to the retention time, \cr 
(2) the cumulative sum of the ion count is calculated (TIC), \cr 
(3) the quantiles are calculated according to the \code{probs} argument, e.g.
when \code{probs} is set to \code{c(0, 0.25, 0.5, 0.75, 1)} the 0\%, 25\%, 
50\%, 75\%, and 100\% quantile is calculated, \cr 
(4) the retention time/relative retention time (retention time divided by 
the total run time taking into account the minimum retention time) is 
calculated, \cr 
(5) the (relative) duration of the LC run after which the cumulative
TIC exceeds (for the first time) the respective quantile of the
cumulative TIC is calculated and returned. \cr
}
\details{
MS:4000054
synonym: "RT-TIC-Q1" RELATED [PMID:24494671] \cr
synonym: "RT-TIC-Q2" RELATED [PMID:24494671] \cr
synonym: "RT-TIC-Q3" RELATED [PMID:24494671] \cr
synonym: "RT-TIC-Q4" RELATED [PMID:24494671] \cr
is_a: MS:4000004 ! n-tuple \cr
relationship: has_metric_category MS:4000009 ! ID free metric \cr
relationship: has_metric_category MS:4000012 ! single run based metric \cr
relationship: has_metric_category MS:4000016 ! retention time metric \cr
relationship: has_metric_category MS:4000017 ! chromatogram metric \cr
relationship: has_value_type xsd:float ! The allowed value-type for this CV term \cr
relationship: has_units UO:0000191 ! fraction \cr
}
\examples{
library(S4Vectors)
library(Spectra)

spd <- DataFrame(
    msLevel = c(2L, 2L, 2L),
    polarity = c(1L, 1L, 1L),
    id = c("HMDB0000001", "HMDB0000001", "HMDB0001847"),
    name = c("1-Methylhistidine", "1-Methylhistidine", "Caffeine"))
## Assign m/z and intensity values
spd$mz <- list(
    c(109.2, 124.2, 124.5, 170.16, 170.52),
    c(83.1, 96.12, 97.14, 109.14, 124.08, 125.1, 170.16),
    c(56.0494, 69.0447, 83.0603, 109.0395, 110.0712,
        111.0551, 123.0429, 138.0662, 195.0876))
spd$intensity <- list(
    c(3.407, 47.494, 3.094, 100.0, 13.240),
    c(6.685, 4.381, 3.022, 16.708, 100.0, 4.565, 40.643),
    c(0.459, 2.585, 2.446, 0.508, 8.968, 0.524, 0.974, 100.0, 40.994))
spd$rtime <- c(9.44, 9.44, 15.84)
sps <- Spectra(spd)
ticQuartersRtFraction(spectra = sps, msLevel = 2L)
}
\author{
Thomas Naake, Johannes Rainer
}
