% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/QTLExperiment.R
\docType{class}
\name{QTLExperiment-class}
\alias{QTLExperiment-class}
\alias{QTLExperiment}
\alias{coerce,SummarizedExperiment,QTLExperiment-method}
\alias{coerce,RangedSummarizedExperiment,QTLExperiment-method}
\title{An S4 class to represent QTL summary statistics.}
\arguments{
\item{...}{Arguments passed to the \code{\link{SummarizedExperiment}}
constructor to fill the slots of the base class.}

\item{state_id}{An array of state IDs the length of ncol(QTLe).}

\item{feature_id}{An array of feature IDs the length of nrow(QTLe).}

\item{variant_id}{An array of variant IDs the length of nrow(QTLe).}
}
\value{
A QTLExperiment object.
}
\description{
The QTLExperiment class is designed to represent multi-state QTL
data. It inherits from the \linkS4class{RangedSummarizedExperiment} class.
In addition, the class supports storage of multi-state adjusted
beta and betaSE results (e.g., mash) and
storage of summary results (e.g., pairwise sharing).
}
\details{
In this class, rows should represent associations (feature_id:variant_id
pairs) while columns represent states (e.g. tissues). Assays include betas
and error associated with the betas (e.g. standard errors).
As with any \linkS4class{SummarizedExperiment} derivative,
different information (e.g., test-statistics, significance calls) can be
stored in user defined \code{\link{assay}} slots, and additional row and
column metadata can be attached using \code{\link{rowData}} and
\code{\link{colData}}, respectively.

The extra arguments in the constructor (\code{\link{feature_id}},
\code{\link{variant_id}}, and \code{\link{state_id}})
represent the main extensions implemented in the QTLExperiment
class. This enables a consistent, formalized representation of key aspects
of multi-state QTL data that are universal to the data structure.
that are commonly encountered during single-cell data analysis.
Readers are referred to the specific documentation pages for more details.

A QTLe can also be coerced from a \linkS4class{SummarizedExperiment} or
\linkS4class{RangedSummarizedExperiment} instance.
}
\section{Slots}{

\describe{
\item{\code{int_rowData}}{A DataFrame containing at minimum feature_id and variant_id information}

\item{\code{int_colData}}{A DataFrame containing at minimum state_id information}

\item{\code{int_metadata}}{A list of additional metadata items to store}
}}

\examples{
nStates <- 10
nQTL <- 100
betas <- matrix(rnorm(nStates * nQTL), ncol=nStates)
error <- matrix(abs(rnorm(nStates * nQTL)), ncol=nStates)

qtle <- QTLExperiment(assays=list(betas=betas, errors=error),
                      feature_id=sample(1:10, nQTL, replace=TRUE),
                      variant_id=sample(seq(1e3:1e5), nQTL),
                      state_id=LETTERS[1:nStates])
qtle

## coercion from SummarizedExperiment
mock_sumstats <- mockSummaryStats(nStates=10, nQTL=100)
se <- SummarizedExperiment(assays=list(betas=mock_sumstats$betas,
                                       errors=mock_sumstats$errors))
as(se, "QTLExperiment")

}
\author{
Christina B Azodi
}
