% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtle_assays.R
\docType{methods}
\name{qtle-assays}
\alias{qtle-assays}
\alias{betas}
\alias{betas<-}
\alias{betas,QTLExperiment-method}
\alias{betas<-,QTLExperiment-method}
\alias{errors}
\alias{errors<-}
\alias{errors,QTLExperiment-method}
\alias{errors<-,QTLExperiment-method}
\alias{pvalues}
\alias{pvalues<-}
\alias{pvalues,QTLExperiment-method}
\alias{pvalues<-,QTLExperiment-method}
\alias{lfsrs}
\alias{lfsrs<-}
\alias{lfsrs,QTLExperiment-method}
\alias{lfsrs<-,QTLExperiment-method}
\title{Named assay getters and setters}
\value{
For \code{assays}, returns the value stored in the requested 
\code{\link{assay}}.

For \code{assays<-value}, the relevant slot of the \linkS4class{QTLExperiment} 
is updated.
}
\description{
These are methods for getting or setting \code{assay(qtle, i=X, ...)}
where \code{qtle} is a \linkS4class{QTLExperiment} object and
\code{X} is the name of the method. For example, \code{betas} will get or
set \code{X="betas"}.
}
\section{Available methods}{

Here \code{x} is a \linkS4class{QTLExperiment} object,
\code{value} is a matrix-like object with the same dimensions as \code{x},
and \code{...} are further arguments passed to \code{\link{assay}}
(for the getter) or \code{\link{assay<-}} (for the setter).

\describe{
\item{\code{betas(x, ...)}, \code{betas(x, ...) <- value}:}{
Get or set a matrix of raw betas, i.e., QTL effect sizes.
}
\item{\code{errors(x, ...)}, \code{errors(x, ...) <- value}:}{
Get or set a matrix of raw beta standard errors.
}
\item{\code{pvalues(x, ...)}, \code{pvalues(x, ...) <- value}:}{
Get or set a matrix of raw significance scores (e.g. pvals, qvals)
}
\item{\code{lfsrs(x, ...)}, \code{lfsrs(x, ...) <- value}:}{
Get or set a matrix of local false sign rates.
}
}
}

\examples{
qtle <- mockQTLE()
new_betas <- matrix(rnorm(nrow(qtle)*ncol(qtle)), ncol=ncol(qtle))
row.names(new_betas) <- row.names(qtle)
colnames(new_betas) <- colnames(qtle)
betas(qtle) <- new_betas
dim(betas(qtle))

}
\seealso{
\code{\link{assay}} and \code{\link{assay<-}}, for the wrapped methods.
}
\author{
Christina B Azodi, Amelia Dunstone
}
