% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/col_ids.R
\docType{methods}
\name{qtle-col_ids}
\alias{qtle-col_ids}
\alias{state_id}
\alias{state_id<-}
\alias{state_id,QTLExperiment-method}
\alias{state_id<-,QTLExperiment-method}
\title{Named colData getters and setters}
\value{
For \code{state_id}, a vector is returned containing the name of the
state tested in each association.
For \code{state_id<-}, a modified \code{object} is returned with the
updated state_ids in \code{\link{colData}}, \code{\link{int_colData}}, and
in the row.names of the \linkS4class{QTLExperiment} object.
}
\description{
These are methods for getting or setting protected colData columns (i.e.
state_id).
}
\details{
QTL are associations between a genetic variant and a quantitative state.
The \code{state_id} methods can be used to get or set state IDs for all
tests in a \linkS4class{QTLExperiment} object. The values are
stored in the \code{\link{colData}} and in the \code{\link{int_colData}} as
the \code{\link{state_id}} field so it can be easily accessed but not
accidentally removed or overwritten.
}
\section{Available methods}{

Here \code{x} is a \linkS4class{QTLExperiment} object,
\code{value} is a matrix-like object with the same dimensions as \code{x},
and \code{...} are further arguments passed to \code{\link{state_id}}
(for the getter) or \code{\link{state_id<-}} (for the setter).

\describe{
\item{\code{state_id(x, ...)}, \code{state_id(x, ...) <- value}:}{
Get or set the state (i.e. column) names.
}
}
}

\examples{
qtle <- mockQTLE()
state_id(qtle) <- sample(LETTERS, ncol(qtle), replace=TRUE)
state_id(qtle)

}
\author{
Christina B Azodi
}
