% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtle_combine.R
\docType{methods}
\name{QTLe-combine}
\alias{QTLe-combine}
\alias{cbind,QTLExperiment-method}
\alias{rbind,QTLExperiment-method}
\title{Combining QTLExperiment objects}
\value{
A \linkS4class{QTLExperiment} object.
}
\description{
An overview of methods to combine multiple
\linkS4class{QTLExperiment} objects by row or column.
These methods ensure that all data fields remain synchronized when states
or associations are added or removed.
}
\section{Combining}{

In the following examples, \code{...} contains one or more
\linkS4class{QTLExperiment} object.
\describe{
\item{\code{rbind(..., deparse.level=1)}:}{Returns a
\linkS4class{QTLExperiment} object where all objects are combined
row-wise. Metadata is combined as in
\code{?"\link{rbind,SummarizedExperiment-method}"}. The \code{deparse.level}
specifies how row.names are generated as described in
\code{?\link[base]{rbind}}.
}

\item{\code{cbind(..., deparse.level=1)}:}{Returns a
\linkS4class{QTLExperiment} object where all objects are combined
column-wise. Metadata is combined
as in \code{?"\link{cbind,SummarizedExperiment-method}"}. The
\code{deparse.level} specifies how colnames are generated as described in
\code{?\link[base]{cbind}}.
}
}
}

\examples{
qtle <- mockQTLE()
qtle2 <- qtle
feature_id(qtle2) <- paste0("x", feature_id(qtle2))
rbind(qtle, qtle2)

qtle2 <- qtle
state_id(qtle2) <- paste0("x", state_id(qtle2))
cbind(qtle, qtle2)


}
\author{
Christina B Azodi
}
