% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtle_internals.R
\docType{methods}
\name{QTLe-internals}
\alias{QTLe-internals}
\alias{int_colData}
\alias{int_rowData}
\alias{int_metadata}
\alias{int_colData,QTLExperiment-method}
\alias{int_rowData,QTLExperiment-method}
\alias{int_metadata,QTLExperiment-method}
\alias{int_colData<-}
\alias{int_rowData<-}
\alias{int_metadata<-}
\alias{int_colData<-,QTLExperiment-method}
\alias{int_rowData<-,QTLExperiment-method}
\alias{int_metadata<-,QTLExperiment-method}
\alias{colData,QTLExperiment-method}
\alias{rowData,QTLExperiment-method}
\alias{parallel_slot_names,QTLExperiment-method}
\title{Internal QTLExperiment functions}
\value{
For \code{assays}, returns the value stored in the requested field 
of the internal rowData, colData or metaData.

 For \code{assays<-value}, the relevant internal field of the \linkS4class{QTLExperiment} 
 is updated.
}
\description{
Methods to get or set internal fields from the QTLExperiment class.
These functions are intended for package developers who want to make changes
or improvements to the object without breaking user code or to add protected
fields to a QTLExperiment. They should \emph{not} be used by general users.
}
\section{Getters}{

Here \code{x} is a \linkS4class{QTLExperiment}.
\describe{
\item{\code{int_rowData(x)}:}{Returns a \linkS4class{DataFrame} of
internal row metadata, with number of rows equal to \code{nrow(x)} (analogous
to the user-visible \code{\link{rowData}}).}
\item{\code{int_colData(x)}:}{Returns a \linkS4class{DataFrame} of internal
column metadata, with number of rows equal to \code{ncol(x)} (analogous to
the user-visible \code{\link{colData}}).}
\item{\code{int_metadata(x)}:}{Returns a list of internal metadata (analogous
 to the user-visible \code{\link{metadata}}).}
}

The following methods can return visible and internal data in a single
DataFrame.
\describe{
\item{\code{rowData(x, ..., internal=TRUE)}:}{Returns a
\linkS4class{DataFrame} of the user-visible row metadata with the internal
row metadata added column-wise. A warning is emitted if the user-visible
metadata column names overlap with the internal fields. Any arguments in
\code{...} are passed to \code{\link{rowData,SummarizedExperiment-method}}.}

\item{\code{colData(x, ..., internal=TRUE)}:}{Returns a
\linkS4class{DataFrame} of the user-visible column metadata with the internal
column metadata added column-wise. A warning is emitted if the user-visible
metadata column names overlap with the internal fields. Any arguments in
\code{...} are passed to \code{\link{colData,SummarizedExperiment-method}}.}
}
}

\section{Setters}{

Here \code{x} is a \linkS4class{QTLExperiment}.
\describe{
\item{\code{int_rowData(x) <- value}:}{Replaces the internal row
metadata with \code{value}, a \linkS4class{DataFrame} with number of rows
equal to \code{nrow(x)} (analogous to the user-visible
\code{\link{rowData<-}}).}
\item{\code{int_colData(x) <- value}:}{Replaces the internal column metadata
 with \code{value}, a \linkS4class{DataFrame} with number of rows equal to
 \code{ncol(x)} (analogous to the user-visible \code{\link{colData<-}}).}
\item{\code{int_metadata(x) <- value}:}{Replaces the internal metadata with
\code{value} (analogous to the user-visible \code{\link{metadata<-}}).}
}
}

\section{Comments}{

The internal metadata fields store additional elements that are parallel to
the rows or columns of a \linkS4class{QTLExperiment} class. This
avoids the need to specify new slots and adjust the subsetting/combining code
for a new data element.

These elements being internal is important as it ensures that the
implementation details are abstracted away. User interaction with these
internal fields should be done via the designated getter and setter methods
(e.g., \code{\link{feature_id}}), providing developers with freedom to change
the internal representation without breaking user code.
}

\examples{
qtle <- mockQTLE()
int_metadata(qtle)$whee <- 1
}
\seealso{
\code{\link{colData}}, \code{\link{rowData}} and \code{\link{metadata}} for
the user-visible equivalents.
}
\author{
Christina B Azodi
}
