% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mockData.R
\docType{methods}
\name{mockQTLE}
\alias{mockQTLE}
\alias{mockSummaryStats}
\alias{mockMASHR}
\alias{mockMASHR_FIT}
\title{Mock data for the QTLExperiment object}
\usage{
mockQTLE(nStates = 10, nQTL = 100, names = TRUE)

mockSummaryStats(nStates = 10, nQTL = 100, names = TRUE)

mockMASHR(nStates = 10, nQTL = 100)

mockMASHR_FIT(nStates = 10, nQTL = 100)
}
\arguments{
\item{nStates}{Number of states}

\item{nQTL}{Number of QTL associations}

\item{names}{Logical to include column and row names}
}
\value{
an object containing simulated data.
}
\description{
Functions to create fake input data for QTLExperiments.
}
\examples{
nStates <- 6
nQTL <- 40

# Mock QTLExperiment data

qtle <- mockQTLE(nStates, nQTL)
dim(qtle)

mock_summary_stats <- mockSummaryStats(nStates=nStates, nQTL=nQTL)
mock_summary_stats$betas
mock_summary_stats$errors
mock_summary_stats$pvalues

# Mock MASHR data

mockr_sim <- mockMASHR(nStates=nStates, nQTL=nQTL)
mockr_sim$B
mockr_sim$Bhat
mockr_sim$Shat

}
\author{
Christina B Azodi, Amelia Dunstone
}
