% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtle_name.R
\docType{methods}
\name{QTLe-name}
\alias{QTLe-name}
\alias{mainExpName}
\alias{mainExpName,QTLExperiment-method}
\alias{mainExpName<-}
\alias{mainExpName<-,QTLExperiment,character_OR_NULL-method}
\title{Return the name of a \linkS4class{QTLExperiment} object.}
\arguments{
\item{x}{A \linkS4class{QTLExperiment} object.}

\item{value}{Any character-like object or \code{NULL} to
remove existing labels.}
}
\value{
For \code{mainExpName(x)}, returns the name associated to \code{x}.

For \code{mainExpName(x) <- value}, the name of the object \code{x} is updated.
}
\description{
Returns the name of an object of class \linkS4class{QTLExperiment}.
}
\section{Available methods}{

In the following code snippets, \code{x} is a
\linkS4class{QTLExperiment} objects.

\describe{
\item{\code{mainExpName(x)}:}{Return the name assigned to \code{x}.}
\item{\code{mainExpName(x) <- value:}}{Change the name assigned to \code{x} 
to \code{value}.}
\item{\code{mainExpName(x) <- NULL:}}{Remove the name associated to \code{x}.}
}
}

\examples{
qtle <- mockQTLE()
mainExpName(qtle)
mainExpName(qtle) <- "test_name"
mainExpName(qtle)

}
\seealso{
\linkS4class{QTLExperiment}, for the underlying class definition.
}
\author{
Christina B. Azodi
}
