% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row_ids.R
\docType{methods}
\name{qtle-row_ids}
\alias{qtle-row_ids}
\alias{feature_id}
\alias{feature_id<-}
\alias{feature_id,QTLExperiment-method}
\alias{feature_id<-,QTLExperiment-method}
\alias{variant_id}
\alias{variant_id<-}
\alias{variant_id,QTLExperiment-method}
\alias{variant_id<-,QTLExperiment-method}
\title{Named rowData getters and setters}
\value{
For \code{feature_id}, a vector is returned containing the name of the
feature tested in each association.
For \code{feature_id<-}, a modified \code{object} is returned with the
updated feature_ids in \code{\link{rowData}}, \code{\link{int_rowData}}, and
in the row.names of the \linkS4class{QTLExperiment} object.
For \code{variant_id}, a vector is returned containing the name of the
variant tested in each association.
For \code{variant_id<-}, a modified \code{object} is returned with the
updated variant_ids in \code{\link{rowData}}, \code{\link{int_rowData}}, and
in the row.names of the \linkS4class{QTLExperiment} object.
}
\description{
These are methods for getting or setting protected rowData columns (i.e.
feature_id and variant_id).
}
\details{
QTL are associations between a genetic variants and a quantitative feature.
The \code{\link{feature_id}} and \code{\link{variant_id}} methods can be used
to get or set feature IDs and variant IDs, respectively, across a
\linkS4class{QTLExperiment} object. The values are stored in the
\code{\link{rowData}} and in the \code{\link{int_rowData}} compartments so
they can be easily accessed but not accidentally removed or overwritten.
}
\section{Available methods}{

Here \code{x} is a \linkS4class{QTLExperiment} object,
\code{value} is a matrix-like object with the same dimensions as \code{x},
and \code{...} are further arguments passed to \code{\link{feature_id}}
(for the getter) or \code{\link{feature_id<-}} (for the setter).

\describe{
\item{\code{feature_id(x, ...)}, \code{feature_id(x, ...) <- value}:}{
Get or set the feature (e.g. gene, metabolite) names.
}
\item{\code{variant_id(x, ...)}, \code{variant_id(x, ...) <- value}:}{
Get or set the variant (i.e. SNP) names.
}
}
}

\examples{
qtle <- mockQTLE()
feature_id(qtle) <- sample(LETTERS, nrow(qtle), replace=TRUE)
feature_id(qtle)
variant_id(qtle) <- sample(paste0("rsid", 1:100), nrow(qtle), replace=TRUE)
variant_id(qtle)

}
\seealso{
\linkS4class{QTLExperiment}, for the underlying class definition.
}
\author{
Christina B Azodi
}
