% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtle_subset.R
\docType{methods}
\name{QTLe-subset}
\alias{QTLe-subset}
\alias{[,QTLExperiment,ANY-method}
\alias{[,QTLExperiment,ANY,ANY-method}
\alias{[,QTLExperiment,ANY,ANY,ANY-method}
\alias{[<-,QTLExperiment,ANY,ANY,QTLExperiment-method}
\title{Subsetting and replacing data in QTLExperiment objects}
\value{
A \linkS4class{QTLExperiment} object.
}
\description{
Includes methods to subset a \linkS4class{QTLExperiment} object by
row and/or column and methods to replace all data for the specified rows
and/or columns with another value. These methods ensure that all data fields
remain synchronized when states or associations are removed.
}
\section{Subsetting}{

In the following, \code{x} is a \linkS4class{QTLExperiment} object.

\describe{
\item{\code{x[i, j, ..., drop=TRUE]}:}{Returns a QTLExperiment
 containing the specified rows \code{i} and columns \code{j}, where \code{i}
 and \code{j} can be a logical, integer or character vector of subscripts,
 indicating the rows and columns, respectively, to retain. If either \code{i}
 or \code{j} is missing, than subsetting is only performed in the specified
 dimension. Arguments in \code{...} and \code{drop} are passed to
 \code{\link{[,SummarizedExperiment-method}}.}
}
}

\section{Replacing}{

In the following, \code{x} is a \linkS4class{QTLExperiment} object.

\describe{
\item{\code{x[i, j, ...] <- value}:}{Replaces all data for rows \code{i} and
columns {j} with the corresponding fields in a QTLExperiment
\code{value}, where \code{i} and \code{j} can be a logical, integer, or
character vector of subscripts, indicating the rows and columns,
respectively, to retain. If either \code{i} or \code{j} is missing, than
subsetting is only performed in the specified dimension. If both are missing,
\code{x} is replaced entirely with \code{value}. Arguments in \code{...} are
passed to the corresponding \linkS4class{SummarizedExperiment} method.}
}
}

\examples{
qtle <- mockQTLE()

# Subsetting:
qtle[1:10,]
qtle[,1:5]

# Can also use subset()
qtle$WHEE <- sample(c("A", "B", "C"), ncol(qtle), replace=TRUE)
subset(qtle, , WHEE=="A")

# Can also use split()
split(qtle, sample(c("A", "B", "C"), nrow(qtle), replace=TRUE))

}
\author{
Christina B Azodi
}
