% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updateObject.R
\name{updateObject}
\alias{updateObject}
\alias{updateObject,QTLExperiment-method}
\title{Update a QTLExperiment object}
\usage{
\S4method{updateObject}{QTLExperiment}(object, ..., verbose = FALSE)
}
\arguments{
\item{object}{An old \linkS4class{QTLExperiment} object.}

\item{...}{Additional arguments that are ignored.}

\item{verbose}{Logical scalar indicating whether a message should be emitted
as the object is updated.}
}
\value{
An updated version of \code{object}.
}
\description{
Update \linkS4class{QTLExperiment} objects to the latest version of
the class structure. This is usually called by internal methods rather than
by users or downstream packages.
}
\details{
This function updates the QTLExperiment to match changes in the
internal class representation. Changes are as follows:
\itemize{
\item No updates yet.
}
}
\examples{
qtle <- mockQTLE()
objectVersion(qtle)

qtle_new <- QTLExperiment::updateObject(qtle)

}
\seealso{
\code{\link{objectVersion}}, which is used to determine if the object is up-to-date.
}
\author{
Christina B Azodi
}
