\name{plot3CPETRes-methods}
\docType{methods}
\alias{plot3CPETRes}
\alias{plot3CPETRes-methods}
\alias{plot3CPETRes,ChromMaintainers-method}
\title{ Plotting clustering results }
\description{
  This method enables the user the generate different types of plots to visualize the results.
}

\usage{
\S4method{plot3CPETRes}{ChromMaintainers}(object, path="", W=14, H=7 , 
          type=c("heatmap","clusters","curve","avgCurve","netSim", "networks"),
          byEdge=TRUE, layoutfct=layout.kamada.kawai, \dots)
}
\arguments{
 \item{object}{\emph{(\strong{Required})} a \code{ChromMaintainers} object that contains the results}
 \item{path}{\emph{(optional)} path where to save the plots \emph{should be \code{".pdf"}}. 
 if not provided the plot will be displayed on the screen.}
 \item{W}{\emph{(optional)} The width of the plot in the pdf file.by default it is 14 inch}
 \item{H}{\emph{(optional)} The Height of the plot in the pdf file.by default it is 7 inch}
 \item{type}{type of the plot to generate. It can support the following values (\emph{(default: "heatmap")}): 
 \itemize{
    \item \code{"heatmap"} : Generates a heatmap of the partnership of each DNA interaction to a chromatin maintainer network.
    Each column is a DNA interaction and each row a chromatin maintainer network.
    \item \code{"clusters"} : generates a pair-wise scatter plots of all clusters. 
    \emph{Note:} only supported if the \code{\link{sota}} method was applied.
    \item \code{"curve"} : for each cluster plots the enrichment profile of all the elements.
    \item \code{"avgCurve"} : draws the average curve of the enrichment profile for each clusters.
    \item \code{"netSim"} : plots a heatmap showing the percentage of common proteins or edges between the 
    chromatin maintainer networks. \emph{Note:} generally the similarity between networks is so small
    so the user can set the value in the diagonal to zero and then re-plot or plot the dissimilarity plot.
   	if \code{byEdge = TRUE} a similarity based on the common edges is calculated otherwise by common nodes.
    \item \code{"networks"} : plots all the networks. if this option is chosen a pdf file named \code{"AllGraphs.pdf"}
    is generated in the current working unless the \code{path} parameter is explicitly determined.    
    To get a finer control, the user can specify the type of layout to use, by default the \code{layout.kamada.kawai}
    is used. For additional layout functions you can check the \code{\link{igraph}} package.
    The reason we generate a pdf file because there is a lot of networks and it will not be convenient to display them
    in one plot, or generating multiple plots.
  }}
 \item{byEdge}{\emph{(optional)} if \code{TRUE} and \code{type = "netSim"} then the a heatmap showing the similarity between the 
 chromatin maintainer networks by common edges. if \code{FALSE} the similarity is calculated based 
 on the number of common nodes.
 }
 \item{layoutfct}{\emph{(optional)} The graph layout algorithm to use. by default the \code{layout.kamada.kawai} is used. 
 Additional functions are available in the \code{\link{igraph}} package.}
 \item{\dots}{options for future use.}
}
\value{
Different types of values are returned depending on the type of the plot selected.
\describe{
\item{\code{"heatmap"}}{ returns a list generated by the \code{\link{pheatmap}} method, however it is always empty.}
\item{\code{"clusters","curve","avgCurve"}}{returns a list describing the number of plots per row and column.}
\item{\code{"netSim"}}{returns a list that contains a ggplot2 object and the similarity matrix}
\item{\code{"networks"}}{returns a list of ggplot2 objects, one per network.}
}
}

\author{
Mohamed Nadhir Djekidel (\email{nde12@mails.tsinghua.edu.cn})
}
\seealso{
\code{\link{cluster}}, \code{\link{igraph}}, \code{\link{sota}}
}
\examples{

    ## get the different datasets path
    petFile <- file.path(system.file("example",package="R3CPET"),"HepG2_interactions.txt")  
    tfbsFile <- file.path(system.file("example",package="R3CPET"),"HepG2_TF.txt.gz")  

\dontrun{
    data(RPKMS)
    x <- ChiapetExperimentData(pet = petFile, tfbs=  tfbsFile, IsBed = FALSE, ppiType="HPRD", filter= TRUE) 
    ## build the different indexes
    x <- createIndexes(x)
    
    ## build networks connecting each interacting regions
    nets<- buildNetworks(x)

    ## infer the networks
    hlda<- InferNetworks(nets)

    ## cluster results
    hlda<- clusterInteractions(hlda)

    ## plot a heatmap
    plot3CPETRes(hlda,type="heatmap")

    ## plot clusters pair-wise scatter plots
    plot3CPETRes(hlda,type="clusters")

    ## enrichment plot for the elements in each network
    plot3CPETRes(hlda,type="curve")

    ##  average enrichment plot for the elements in each network
    plot3CPETRes(hlda,type="avgCurve")

    ## heatmap showing the similarity between the different network
    plot3CPETRes(hlda,type="netSim")

    ## plot all the networks in the file "AllGraphs.pdf" 
    nets_plot <- plot3CPETRes(hlda,type="networks")

    ## plot one of the networks
    plot(nets_plot[[3]])

}
}
\keyword{methods}
\keyword{ ~~ other possible keyword(s) ~~ }
