% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot.R
\name{simplenetworkPlot}
\alias{simplenetworkPlot}
\title{simplenetworkPlot}
\usage{
simplenetworkPlot(TOP_model, nFeatures = 50, s = "lambda.min")
}
\arguments{
\item{TOP_model}{A Transferable Omics Prediction model. The output from the
TOP_model function.}

\item{nFeatures}{The number of features that will be plotted. Default: 20}

\item{s}{Lambda value for the lasso model. Default is "lambda.min"}
}
\value{
A simple network plot
}
\description{
simplenetworkPlot
}
\examples{
data(TOP_data_binary, package = "TOP")

x1 <- TOP_data_binary$x1
x2 <- TOP_data_binary$x2
x3 <- TOP_data_binary$x3
y1 <- TOP_data_binary$y1
y2 <- TOP_data_binary$y2
y3 <- TOP_data_binary$y3

set.seed(23)
x_list <- list(x1, x2)
y_list <- list(factor(y1), factor(y2))

model <- TOP_model(x_list, y_list)
simplenetworkPlot(model)
}
