% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_findSibling.R
\name{findSibling}
\alias{findSibling}
\title{find the sibling node}
\usage{
findSibling(tree, node, use.alias = FALSE)
}
\arguments{
\item{tree}{A phylo object.}

\item{node}{A numeric or character vector. Node labels or node numbers.}

\item{use.alias}{A logical value, TRUE or FALSE. The default is FALSE, and
the original node label would be used to name the output; otherwise, the
alias of node label would be used to name the output. The alias of node
label is created by adding a prefix \code{"alias_"} to the node number.}
}
\value{
A vector of nodes. The numeric value is the node number, and the
  vector name is the corresponding node label. If a node has no label, it
  would have NA as name when \code{use.alias = FALSE}, and have the alias of
  node label as name when \code{use.alias = TRUE}.
}
\description{
\code{findSibling} is to find the sibling node of an \code{node} node.
}
\examples{
library(ggtree)
data(tinyTree)
ggtree(tinyTree, branch.length = 'none') +
    geom_text2(aes(label = label), color = "darkorange",
           hjust = -0.1, vjust = -0.7) +
    geom_text2(aes(label = node), color = "darkblue",
               hjust = -0.5, vjust = 0.7)


 findSibling(tree = tinyTree, node = 17)
 findSibling(tree = tinyTree, node = c(13, 17))
}
