% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{build_atlas}
\alias{build_atlas}
\title{Function to combine records into single atlas}
\usage{
build_atlas(matrix_fns = NULL, genes_fn, matrix_objs = NULL, output_fn = NULL)
}
\arguments{
\item{matrix_fns}{character vector of paths to study matrices stored as .rds files.
If a named character vector, then the name will be added as a suffix to the cell type
name in the final matrix. If it is not named, then the filename will be used (without .rds)}

\item{genes_fn}{text file with a single column containing genes and the ordering desired
in the output matrix}

\item{matrix_objs}{Checks to see whether .rds files will be read or R objects in a
local environment. A list of environmental objects can be passed to
matrx_objs, and that names will be used, otherwise defaults to numbers}

\item{output_fn}{output filename for .rds file. If NULL the matrix will be returned instead of
saving}
}
\value{
Combined matrix with all genes given
}
\description{
Function to combine records into single atlas
}
\examples{
pbmc_ref_matrix <- average_clusters(
mat = pbmc_matrix_small,
metadata = pbmc_meta,
cluster_col = "classified",
if_log = TRUE # whether the expression matrix is already log transformed
)
references_to_combine <- list(pbmc_ref_matrix, cbmc_ref)
atlas <- build_atlas(NULL, human_genes_10x, references_to_combine, NULL)
}
