% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{calculate_pathway_gsea}
\alias{calculate_pathway_gsea}
\title{Convert expression matrix to GSEA pathway scores
(would take a similar place in workflow before average_clusters/binarize)}
\usage{
calculate_pathway_gsea(
  mat,
  pathway_list,
  n_perm = 1000,
  scale = TRUE,
  no_warnings = TRUE
)
}
\arguments{
\item{mat}{expression matrix}

\item{pathway_list}{a list of vectors, each named for a specific pathway,
or dataframe}

\item{n_perm}{Number of permutation for fgsea function. Defaults to 1000.}

\item{scale}{convert expr_mat into zscores prior to running GSEA?,
default = FALSE}

\item{no_warnings}{suppress warnings from gsea ties}
}
\value{
matrix of GSEA NES values, cell types as row names,
pathways as column names
}
\description{
Convert expression matrix to GSEA pathway scores
(would take a similar place in workflow before average_clusters/binarize)
}
\examples{
gl <- list(
    "n" = c("PPBP", "LYZ", "S100A9"),
    "a" = c("IGLL5", "GNLY", "FTL")
)

pbmc_avg <- average_clusters(
    mat = pbmc_matrix_small,
    metadata = pbmc_meta,
    cluster_col = "classified"
)

calculate_pathway_gsea(
    mat = pbmc_avg,
    pathway_list = gl
)
}
