% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cellbrowsers.R
\name{get_ucsc_reference}
\alias{get_ucsc_reference}
\title{Build reference atlases from external UCSC cellbrowsers}
\usage{
get_ucsc_reference(cb_url, cluster_col, ...)
}
\arguments{
\item{cb_url}{URL of cellbrowser dataset (e.g. http://cells.ucsc.edu/?ds=cortex-dev).
Note that the URL must contain the ds=dataset-name suffix.}

\item{cluster_col}{annotation field for summarizing gene expression (e.g. clustering,
cell-type name, samples, etc.)}

\item{...}{additional args passed to average_clusters}
}
\value{
reference matrix
}
\description{
Build reference atlases from external UCSC cellbrowsers
}
\examples{
\dontrun{

# many datasets hosted by UCSC have UMI counts in the expression matrix
# set if_log = FALSE if the expression matrix has not been natural log transformed

get_ucsc_reference(cb_url = "https://cells.ucsc.edu/?ds=evocell+mus-musculus+marrow",
                   cluster_col = "Clusters", if_log = FALSE)
                   
get_ucsc_reference(cb_url = "http://cells.ucsc.edu/?ds=muscle-cell-atlas",
                   cluster_col = "cell_annotation",
                   if_log = FALSE)
}
}
