% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyp_dots.R
\name{hyp_dots}
\alias{hyp_dots}
\title{Visualize hyp/multihyp objects as a dots plot}
\usage{
hyp_dots(
  hyp_obj,
  top = 20,
  abrv = 50,
  size_by = c("genesets", "significance", "none"),
  pval = 1,
  fdr = 1,
  val = c("fdr", "pval"),
  title = "",
  merge = FALSE
)
}
\arguments{
\item{hyp_obj}{A hyp or multihyp object}

\item{top}{Limit number of genesets shown}

\item{abrv}{Abbreviation length of geneset labels}

\item{size_by}{Size dots by e.g. c("genesets", "significance", "none")}

\item{pval}{Filter results to be less than pval cutoff}

\item{fdr}{Filter results to be less than fdr cutoff}

\item{val}{Choose significance value for plot e.g. c("fdr", "pval")}

\item{title}{Plot title}

\item{merge}{Use true to merge a multihyp object into one plot}
}
\value{
A ggplot object
}
\description{
Visualize hyp/multihyp objects as a dots plot
}
\examples{
genesets <- msigdb_gsets("Homo sapiens", "C2", "CP:KEGG")

signature <- c("IDH3B","DLST","PCK2","CS","PDHB","PCK1","PDHA1","LOC642502",
               "PDHA2","LOC283398","FH","SDHD","OGDH","SDHB","IDH3A","SDHC",
               "IDH2","IDH1","OGDHL","PC","SDHA","SUCLG1","SUCLA2","SUCLG2")

hyp_obj <- hypeR(signature, genesets, background=2522)

hyp_dots(hyp_obj, val="fdr")

}
