% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactable.R
\name{rctbl_build}
\alias{rctbl_build}
\title{Reactable builder for hyp or mhyp objects}
\usage{
rctbl_build(obj, ...)
}
\arguments{
\item{obj}{A hyp or multihyp object}

\item{...}{Arguments passed to table generators}
}
\description{
Reactable builder for hyp or mhyp objects
}
\examples{
genesets <- msigdb_gsets("Homo sapiens", "C2", "CP:KEGG")$genesets[1:5]

experiment <- list("S1"=c("IDH3B","DLST","PCK2","CS","PDHB","PCK1","PDHA1","LOC642502"),
                   "S2"=c("PDHA2","LOC283398","FH","SDHD","OGDH","SDHB","IDH3A","SDHC"))

mhyp_obj <- hypeR(experiment, genesets, background=2522)

rctbl_build(mhyp_obj)

}
