% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactable.R
\name{rctbl_hyp}
\alias{rctbl_hyp}
\title{Reactable table for hyp objects}
\usage{
rctbl_hyp(
  hyp,
  type = c("inner", "outer"),
  show_emaps = FALSE,
  show_hmaps = FALSE,
  hyp_emap_args = list(top = 25, val = "fdr"),
  hyp_hmap_args = list(top = 25, val = "fdr")
)
}
\arguments{
\item{hyp}{A hyp object}

\item{type}{Use style class for outer or inner tables}

\item{show_emaps}{Option to show enrichment maps in tabs}

\item{show_hmaps}{Option to show hiearchy maps in tabs}

\item{hyp_emap_args}{A list of keyword arguments passed to hyp_emap}

\item{hyp_hmap_args}{A list of keyword arguments passed to hyp_hmap}
}
\description{
Reactable table for hyp objects
}
\examples{
genesets <- msigdb_gsets("Homo sapiens", "C2", "CP:KEGG")$genesets[1:5]

signature <- c("IDH3B","DLST","PCK2","CS","PDHB","PCK1","PDHA1","LOC642502",
              "PDHA2","LOC283398","FH","SDHD","OGDH","SDHB","IDH3A","SDHC",
              "IDH2","IDH1","OGDHL","PC","SDHA","SUCLG1","SUCLA2","SUCLG2")

hyp_obj <- hypeR(signature, genesets, background=2522)

rctbl_hyp(hyp_obj)

}
