% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactable.R
\name{rctbl_mhyp}
\alias{rctbl_mhyp}
\title{Reactable table for multihyp objects}
\usage{
rctbl_mhyp(
  mhyp,
  show_emaps = FALSE,
  show_hmaps = FALSE,
  hyp_emap_args = list(top = 25, val = "fdr"),
  hyp_hmap_args = list(top = 25, val = "fdr")
)
}
\arguments{
\item{mhyp}{A multihyp object}

\item{show_emaps}{Option to show enrichment maps in tabs}

\item{show_hmaps}{Option to show hiearchy maps in tabs}

\item{hyp_emap_args}{A list of keyword arguments passed to hyp_emap}

\item{hyp_hmap_args}{A list of keyword arguments passed to hyp_hmap}
}
\description{
Reactable table for multihyp objects
}
\examples{
genesets <- msigdb_gsets("Homo sapiens", "C2", "CP:KEGG")$genesets[1:5]

experiment <- list("S1"=c("IDH3B","DLST","PCK2","CS","PDHB","PCK1","PDHA1","LOC642502"),
                   "S2"=c("PDHA2","LOC283398","FH","SDHD","OGDH","SDHB","IDH3A","SDHC"))

mhyp_obj <- hypeR(experiment, genesets, background=2522)

rctbl_mhyp(mhyp_obj)

}
