## ----style, echo = FALSE, results = 'asis'------------------------------------
knitr::opts_chunk$set(fig.align = "center")

## ----eval = FALSE-------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  BiocManager::install("lefser")

## ----include=TRUE,results="hide",message=FALSE,warning=FALSE------------------
library(lefser)

## -----------------------------------------------------------------------------
data(zeller14)
zeller14 <- zeller14[, zeller14$study_condition != "adenoma"]

## -----------------------------------------------------------------------------
table(zeller14$study_condition)

## -----------------------------------------------------------------------------
table(zeller14$age_category)

## -----------------------------------------------------------------------------
table(zeller14$age_category, zeller14$study_condition)

## -----------------------------------------------------------------------------
res <- lefser(zeller14, groupCol = "study_condition", blockCol = "age_category")
head(res)

## -----------------------------------------------------------------------------
lefserPlot(res)

## -----------------------------------------------------------------------------
library(phyloseq)
fp <- system.file(
    "extdata", "study_1457_split_library_seqs_and_mapping.zip",
    package = "phyloseq"
)
kostic <- suppressWarnings({
    microbio_me_qiime(fp)
})
counts <- unclass(otu_table(kostic))
colData <- as(sample_data(kostic), "data.frame")
## create a SummarizedExperiment object
SummarizedExperiment(
    assays = list(counts = counts), colData = colData
)

## -----------------------------------------------------------------------------
sessionInfo()

