% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lefser.R
\name{lefser}
\alias{lefser}
\title{R implementation of the LEfSe method}
\usage{
lefser(
  relab,
  kruskal.threshold = 0.05,
  wilcox.threshold = 0.05,
  lda.threshold = 2,
  groupCol = "GROUP",
  blockCol = NULL,
  assay = 1L,
  trim.names = FALSE,
  checkAbundances = TRUE,
  ...,
  expr
)
}
\arguments{
\item{relab}{A \linkS4class{SummarizedExperiment} with relative
abundances in the assay}

\item{kruskal.threshold}{numeric(1) The p-value for the Kruskal-Wallis Rank
Sum Test (default 0.05).}

\item{wilcox.threshold}{numeric(1) The p-value for the Wilcoxon Rank-Sum Test
when 'blockCol' is present (default 0.05).}

\item{lda.threshold}{numeric(1) The effect size threshold (default 2.0).}

\item{groupCol}{character(1) Column name in \code{colData(relab)} indicating
groups, usually a factor with two levels (e.g., \code{c("cases", "controls")};
default "GROUP").}

\item{blockCol}{character(1) Optional column name in \code{colData(relab)}
indicating the blocks, usually a factor with two levels (e.g.,
\code{c("adult", "senior")}; default NULL).}

\item{assay}{The i-th assay matrix in the \code{SummarizedExperiment} ('relab';
default 1).}

\item{trim.names}{Default is \code{FALSE}. If \code{TRUE}, this function extracts
the most specific taxonomic rank of organism.}

\item{checkAbundances}{\code{logical(1)} Whether to check if the assay data in the
\code{relab} input are relative abundances or counts. If counts are found, a
warning will be emitted (default \code{TRUE}).}

\item{expr}{(\code{deprecated}) Use \code{relab} instead. A \linkS4class{SummarizedExperiment}
with relative abundances in the assay}

\item{\ldots}{Additional inputs to lower level functions (not used).}
}
\value{
The function returns a \code{data.frame} with two columns, which are
names of features and their LDA scores.
}
\description{
Perform a LEfSe analysis: the function carries out differential analysis
between two sample groups for multiple features and uses linear discriminant analysis
to establish their effect sizes. Subclass information for each class can be incorporated
into the analysis (see examples). Features with large differences between two sample groups
are identified as biomarkers.
}
\details{
The LEfSe method expects relative abundances in the \code{expr} input. A warning
will be emitted if the column sums do not result in 1. Use the \code{relativeAb}
helper function to convert the data in the \code{SummarizedExperiment} to relative
abundances. The \code{checkAbundances} argument enables checking the data
for presence of relative abundances and can be turned off by setting the
argument to \code{FALSE}.
}
\examples{
    # (1) Using classes only
    data(zeller14)
    # exclude 'adenoma'
    zeller14 <- zeller14[, zeller14$study_condition != "adenoma"]
    res_group <- lefser(relativeAb(zeller14), 
                        groupCol = "study_condition")
    head(res_group)

    # (2) Using classes and sublasses
    data(zeller14)
    # exclude 'adenoma'
    zeller14 <- zeller14[, zeller14$study_condition != "adenoma"]
    res_block <- lefser(relativeAb(zeller14), 
                        groupCol = "study_condition", 
                        blockCol = "age_category")
    head(res_block)
}
