% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lefserPlot.R
\name{lefserPlot}
\alias{lefserPlot}
\title{Plots results from \code{lefser} function}
\usage{
lefserPlot(
  df,
  colors = c("red", "forestgreen"),
  trim.names = TRUE,
  title = "",
  label.font.size = 3
)
}
\arguments{
\item{df}{Data frame produced by \code{lefser}.}

\item{colors}{A character(2). Colors corresponding to class 0 and 1.
Defaults to \code{c("red", "forestgreen")}.}

\item{trim.names}{Under the default (\code{TRUE}), this function extracts the
most specific taxonomic rank of organism.}

\item{title}{A character(1). The title of the plot.}

\item{label.font.size}{A numeric(1). The font size of the feature labels.
The default is \code{3}.}
}
\value{
Function returns plot of effect size scores produced by \code{lefser}.
Positive scores represent the biomarker is more abundant in class '1'.
Negative scores represent the biomarker is more abundant in class '0'.
}
\description{
This function plots the biomarkers found by LEfSe, that are ranked according
to their effect sizes and linked to their abundance in each class.
}
\examples{
example("lefser")
lefserPlot(res_group)

}
