## ----style, echo=FALSE, results='asis'----------------------------------------
BiocStyle::markdown()

## ----setup, echo=FALSE, message=FALSE-----------------------------------------
library(matter)
register(SerialParam())

## ----install, eval=FALSE------------------------------------------------------
#  if (!require("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  
#  BiocManager::install("matter")

## ----library, eval=FALSE------------------------------------------------------
#  library(matter)

## ----atoms--------------------------------------------------------------------
x <- matter_vec(1:10)
y <- matter_vec(11:20)
z <- cbind(x, y)
atomdata(z)

## ----array-1------------------------------------------------------------------
set.seed(1)
a1 <- array(sort(runif(24)), dim=c(4,3,2))

a2 <- matter_arr(a1)
a2

path(a2)

## ----array-2------------------------------------------------------------------
a3 <- matter_arr(type="double", path=path(a2), offset=0, extent=10)
a3

a1[1:10]

## ----matrix-1-----------------------------------------------------------------
set.seed(1)
m1 <- matrix(sort(runif(35)), nrow=5, ncol=7)

m2 <- matter_mat(m1)
m2

## ----matrix-2-----------------------------------------------------------------
m3 <- matter_mat(type="double", path=path(m2), nrow=7, ncol=5, rowMaj=TRUE)
m3

## ----matrix-3-----------------------------------------------------------------
t(m2)

## ----matrix-4-----------------------------------------------------------------
rowMaj(t(m2))
rowMaj(m2)

## ----deferred-1---------------------------------------------------------------
m2 + 100

## ----deferred-2---------------------------------------------------------------
as.matrix(1:5) + m2

## ----deferred-3---------------------------------------------------------------
t(1:7) + m2

## ----lists-1------------------------------------------------------------------
set.seed(1)
l1 <- list(A=runif(10), B=rnorm(15), C=rlnorm(5), D="This is a string!")

l2 <- matter_list(l1)
l2

## ----sparse-1-----------------------------------------------------------------
set.seed(1)
s1 <- matrix(rbinom(35, 10, 0.05), nrow=5, ncol=7)

s2 <- sparse_mat(s1)
s2

## ----sparse-2-----------------------------------------------------------------
atomdata(s2)
atomindex(s2)

## ----sparse-3-----------------------------------------------------------------
s3 <- sparse_mat(atomdata(s2), index=atomindex(s2), nrow=5, ncol=7)
s3

## ----sparse-4-----------------------------------------------------------------
s4 <- sparse_mat(s1, pointers=TRUE)
atomdata(s4)
atomindex(s4)
pointers(s4)

## ----sparse-5-----------------------------------------------------------------
s5 <- sparse_mat(atomdata(s2), index=atomindex(s2), pointers=pointers(s2), nrow=5, ncol=7)
s5

## ----nonuniform-1-------------------------------------------------------------
set.seed(1)
mz <- replicate(5, 100 * sort(runif(sample(10, 1))), simplify=FALSE)
intensity <- lapply(mz, function(m) 10 * runif(length(m)))

layout(matrix(1:4, nrow=2))
for (i in 1:4) plot(mz[[i]], intensity[[i]], type='h', xlim=c(1,100), ylim=c(0,10), xlab="m/z", ylab="intensity", main=paste0("Spectrum ", i))

## ----nonuniform-2-------------------------------------------------------------
spectra <- sparse_mat(intensity, index=mz, domain=1:100, sampler="max", tolerance=0.5)
spectra

## ----nonuniform-3-------------------------------------------------------------
layout(matrix(1:4, nrow=2))
for (i in 1:4) plot(1:100, spectra[,i], type='h', xlim=c(1,100), ylim=c(0,10), xlab="m/z", ylab="intensity", main=paste0("Spectrum ", i))

## ----sparse-deferred-1--------------------------------------------------------
spectra / t(colMeans(spectra))

## ----session-info-------------------------------------------------------------
sessionInfo()

