% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerlawA.R
\name{powerlawA}
\alias{powerlawA}
\title{Interaction matrix with Power-Law network adjacency matrix}
\usage{
powerlawA(n_species, alpha = 3, stdev = 1, s = 0.1, d = -1, symmetric = FALSE)
}
\arguments{
\item{n_species}{integer number of species}

\item{alpha}{numeric power-law distribution parameter. Should be > 1.
(default: \code{alpha = 3.0}) Larger values will give lower interaction
strength heterogeneity, whereas values closer to 1 give strong heterogeneity
in interaction strengths between the species. In other words, values of alpha
close to 1 will give Strongly Interacting Species (SIS).}

\item{stdev}{numeric standard deviation parameter of the normal
distribution with mean 0 from which the elements of the nominal interspecific
interaction matrix N are drawn. (default: \code{stdev = 1})}

\item{s}{numeric scaling parameter with which the final global
interaction matrix A is multiplied. (default: \code{s = 0.1})}

\item{d}{numeric diagonal values, indicating self-interactions (use
negative values for stability). (default: \code{s = 1.0})}

\item{symmetric}{logical scalar returning a symmetric interaction matrix
(default: \code{symmetric=FALSE})}
}
\value{
The interaction matrix A with dimensions (n_species x n_species)
}
\description{
N is the an Interspecific Interaction matrix with values drawn from
a normal distribution H the interaction strength heterogeneity drawn from
a power-law distribution with the parameter alpha, and G the adjacency matrix
of with out-degree that reflects the heterogeneity of the powerlaw.
A scaling factor s may be used to constrain the values of the interaction
matrix to be within a desired range. Diagonal elements of A are defined
by the parameter d.
}
\examples{
# Low interaction heterogeneity
A_low <- powerlawA(n_species = 10, alpha = 3)
# Strong interaction heterogeneity
A_strong <- powerlawA(n_species = 10, alpha = 1.01)

}
\references{
Gibson TE, Bashan A, Cao HT, Weiss ST, Liu YY (2016)
On the Origins and Control of Community Types in the Human Microbiome.
PLOS Computational Biology 12(2): e1004688.
https://doi.org/10.1371/journal.pcbi.1004688
}
