% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomA.R
\name{randomA}
\alias{randomA}
\title{Generate random interaction matrix for GLV model}
\usage{
randomA(
  n_species,
  names_species = NULL,
  diagonal = -0.5,
  connectance = 0.2,
  scale_off_diagonal = 0.1,
  mutualism = 1,
  commensalism = 1,
  parasitism = 1,
  amensalism = 1,
  competition = 1,
  interactions = NULL,
  symmetric = FALSE,
  list_A = NULL
)
}
\arguments{
\item{n_species}{Integer: number of species}

\item{names_species}{Character: names of species. If NULL,
\code{paste0("sp", seq_len(n_species))} is used.
(default: \code{names_species = NULL})}

\item{diagonal}{Values defining the strength of self-interactions. Input can
be a number (will be applied to all species) or a vector of length n_species.
Positive self-interaction values lead to exponential growth.
(default: \code{diagonal = -0.5})}

\item{connectance}{Numeric frequency of inter-species interactions.
i.e. proportion of non-zero off-diagonal terms.
Should be in the interval 0 <= connectance <= 1.
(default: \code{connectance = 0.2})}

\item{scale_off_diagonal}{Numeric: scale of the off-diagonal elements
compared to the diagonal.
(default: \code{scale_off_diagonal = 0.1})}

\item{mutualism}{Numeric: relative proportion of interactions terms
consistent with mutualism (positive <-> positive)
(default: \code{mutualism = 1})}

\item{commensalism}{Numeric: relative proportion of interactions terms
consistent with commensalism (positive <-> neutral)
(default: \code{commensalism = 1})}

\item{parasitism}{Numeric: relative proportion of interactions terms
consistent with parasitism (positive <-> negative)
(default: \code{parasitism = 1})}

\item{amensalism}{Numeric: relative proportion of interactions terms
consistent with amensalism (neutral <-> negative)
(default: \code{amensalism = 1})}

\item{competition}{Numeric: relative proportion of interactions terms
consistent with competition (negative <-> negative)
(default: \code{competition = 1})}

\item{interactions}{Numeric: values of the n_species^2 pairwise interaction
strengths. Diagonal terms will be replaced by the 'diagonal' parameter
If NULL, interactions are drawn from
\code{runif(n_species^2, min=0, max=abs(diagonal))}.
Negative values are first converted to positive then the signs are defined by
the relative weights of the biological interactions (i.e. mutualism,
commensalism, parasitism, amensalism, competition)
(default: \code{interactions = NULL})}

\item{symmetric}{Logical: whether the strength of mutualistic and competitive
interactions are symmetric. This is implemented by overwrite a half of the
matrix, so the proportions of interactions might deviate from expectations.
(default: \code{symmetric=FALSE})}

\item{list_A}{List: a list of matrices generated by randomA. Used to support
different groups of interactions. If NULL (by default), no group is
considered. Otherwise the given list of matrices will overwrite values around
the diagonal.
(default: \code{list_A = NULL})}
}
\value{
\code{randomA} returns a matrix A with dimensions (n_species x n_species)
}
\description{
Generates a random interaction matrix for Generalized Lotka-Volterra (GLV) model.
}
\examples{

dense_A <- randomA(
    n_species = 10,
    scale_off_diagonal = 1,
    diagonal = -1.0,
    connectance = 0.9
)

sparse_A <- randomA(
    n_species = 10,
    diagonal = -1.0,
    connectance = 0.09
)

user_interactions <- rbeta(n = 10^2, .5, .5)
user_A <- randomA(n_species = 10, interactions = user_interactions)

competitive_A <- randomA(
    n_species = 10,
    mutualism = 0,
    commensalism = 0,
    parasitism = 0,
    amensalism = 0,
    competition = 1,
    connectance = 1,
    scale_off_diagonal = 1
)

parasitism_A <- randomA(
    n_species = 10,
    mutualism = 0,
    commensalism = 0,
    parasitism = 1,
    amensalism = 0,
    competition = 0,
    connectance = 1,
    scale_off_diagonal = 1,
    symmetric = TRUE
)

list_A <- list(dense_A, sparse_A, competitive_A, parasitism_A)
groupA <- randomA(n_species = 40, list_A = list_A)

}
