% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateHubbell.R
\name{simulateHubbell}
\alias{simulateHubbell}
\title{Hubbell's neutral model simulation}
\usage{
simulateHubbell(
  n_species,
  M,
  carrying_capacity = 1000,
  k_events = 10,
  migration_p = 0.02,
  t_skip = 0,
  t_end,
  norm = FALSE
)
}
\arguments{
\item{n_species}{integer amount of different species initially
in the local community}

\item{M}{integer amount of different species in the metacommunity,
including those of the local community}

\item{carrying_capacity}{integer value of fixed amount of individuals in the local community
(default: \code{carrying_capacity = 1000})}

\item{k_events}{integer value of fixed amount of deaths of local community
individuals in each generation (default: \code{k_events = 10})}

\item{migration_p}{numeric immigration rate: the probability that a death in the local
community is replaced by a migrant of the metacommunity rather than by
the birth of a local community member (default: \code{migration_p = 0.02})}

\item{t_skip}{integer number of generations that should not be included
in the outputted species abundance matrix. (default: \code{t_skip = 0})}

\item{t_end}{integer number of simulations to be simulated}

\item{norm}{logical scalar choosing whether the time series should be
returned with the abundances as proportions (\code{norm = TRUE}) or
the raw counts (default: \code{norm = FALSE})}
}
\value{
\code{simulateHubbell} returns a TreeSummarizedExperiment class
object
}
\description{
Neutral species abundances simulation according to the Hubbell model.
}
\examples{
tse <- simulateHubbell(
    n_species = 8, M = 10, carrying_capacity = 1000, k_events = 50,
    migration_p = 0.02, t_end = 100
)

}
\references{
Rosindell, James et al. "The unified neutral theory of
biodiversity and biogeography at age ten." Trends in ecology & evolution
vol. 26,7 (2011).
}
