% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateRicker.R
\name{simulateRicker}
\alias{simulateRicker}
\title{Generate time series with the Ricker model}
\usage{
simulateRicker(
  n_species,
  A,
  names_species = NULL,
  x0 = runif(n_species),
  carrying_capacities = runif(n_species),
  error_variance = 0.05,
  explosion_bound = 10^8,
  t_end = 1000,
  norm = FALSE,
  ...
)
}
\arguments{
\item{n_species}{Integer: number of species}

\item{A}{interaction matrix}

\item{names_species}{Character: names of species. If NULL,
\code{paste0("sp", seq_len(n_species))} is used.
(default: \code{names_species = NULL})}

\item{x0}{Numeric: initial abundances of simulated species. If NULL,
\code{runif(n = n_species, min = 0, max = 1)} is used.}

\item{carrying_capacities}{numeric carrying capacities. If NULL,
\code{runif(n = n_species, min = 0, max = 1)} is used.}

\item{error_variance}{Numeric: the variance of measurement error.
By default it equals to 0, indicating that the result won't contain any
measurement error. This value should be non-negative.
(default: \code{error_variance = 0.05})}

\item{explosion_bound}{numeric value of boundary for explosion
(default: \code{explosion_bound = 10^8})}

\item{t_end}{integer number of simulations to be simulated}

\item{norm}{logical scalar returning normalised abundances (proportions
in each generation) (default: \code{norm = FALSE})}

\item{...}{additional parameters, see \code{\link{utils}} to know more.}
}
\value{
\code{simulateRicker} returns a TreeSummarizedExperiment class object
}
\description{
The Ricker model is a discrete version of the generalized
Lotka-Volterra model and is implemented here as proposed by Fisher and Mehta
in PLoS ONE 2014.
}
\examples{
A <- powerlawA(10, alpha = 1.01)
tse <- simulateRicker(n_species = 10, A, t_end = 100)

}
\references{
Fisher & Mehta (2014). Identifying Keystone Species in the Human
Gut Microbiome from Metagenomic Timeseries using Sparse Linear Regression.
PLoS One 9:e102451
}
