% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateSOI.R
\name{simulateSOI}
\alias{simulateSOI}
\title{Self-Organised Instability model (SOI) simulation}
\usage{
simulateSOI(
  n_species,
  x0 = NULL,
  names_species = NULL,
  carrying_capacity = 1000,
  A = NULL,
  k_events = 5,
  t_end = 1000,
  metacommunity_probability = runif(n_species, min = 0.1, max = 0.8),
  death_rates = runif(n_species, min = 0.01, max = 0.08),
  norm = FALSE
)
}
\arguments{
\item{n_species}{Integer: number of species}

\item{x0}{a vector of initial community abundances
If (default: \code{x0 = NULL}), based on migration rates}

\item{names_species}{Character: names of species. If NULL,
\code{paste0("sp", seq_len(n_species))} is used.
(default: \code{names_species = NULL})}

\item{carrying_capacity}{integer community size, number of available sites
(individuals)}

\item{A}{matrix: interaction matrix defining the positive and negative
interactions between n_species. If NULL, \code{powerlawA(n_species)} is used.
(default: \code{A = NULL})}

\item{k_events}{integer number of transition events that are allowed to take
place during one leap. (default: \code{k_events = 5}).
Higher values reduce runtime, but also accuracy of the simulation.}

\item{t_end}{Numeric: the end time of the simulation, defining the
modeled time length of the community.
(default: \code{t_end = 1000})}

\item{metacommunity_probability}{Numeric: Normalized probability distribution
of the likelihood that species from the metacommunity can enter the community
during the simulation. By default, \code{runif(n_species, min = 0.1, max = 0.8)}
is used.
(default: \code{metacommunity_probability = runif(n_species, min = 0.1, max = 0.8)})}

\item{death_rates}{Numeric: death rates of each species. By default,
\code{runif(n_species, min = 0.01, max = 0.08)} is used.
(default: \code{death_rates = runif(n_species, min = 0.01, max = 0.08)})}

\item{norm}{logical scalar indicating whether the time series should be
returned with the abundances as proportions (\code{norm = TRUE})
or the raw counts (default: \code{norm = FALSE})}
}
\value{
\code{simulateSOI} returns a TreeSummarizedExperiment class object
}
\description{
Generate time-series with The Self-Organised Instability (SOI) model.
Implements a K-leap method for accelerating stochastic simulation.
}
\examples{
# Generate interaction matrix
A <- miaSim::powerlawA(10, alpha = 1.2)
# Simulate data from the SOI model
tse <- simulateSOI(
    n_species = 10, carrying_capacity = 1000, A = A,
    k_events = 5, x0 = NULL, t_end = 150, norm = TRUE
)

}
