% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mia.R
\docType{data}
\name{GlobalPatterns}
\alias{GlobalPatterns}
\title{GlobalPatterns}
\format{
A TreeSummarizedExperiment with 19216 features and 26 samples. The
rowData contains taxonomic information at Kingdom, Phylum, Class, Order,
Family, Genus and Species levels. The colData includes:

\describe{
\item{X.SampleID}{Sample ID taken from the corresponding study}
\item{Primer}{primer used for sequencing}
\item{Final_Barcode}{final barcode (6 nucleotides)}
\item{Barcode_truncated_plus_T}{truncated barcode with an added tyrosine
(6 nucleotides)}
\item{Barcode_full_length}{complete barcode with a length of 11 nucleotides}
\item{SampleType}{sampling type by collection site (Soil, Feces, Skin,
Tongue, Freshwater, Creek Freshwater, Ocean, Estuary Sediment and Mock)}
\item{Description}{additional information (sampling location, environmental
factors and study type)}
}
}
\usage{
data(GlobalPatterns)
}
\description{
GlobalPatterns compared the microbial communities from 25 environmental samples
and three known "mock communities" at a an average depth of 3.1 million reads
per sample. Authors reproduced diversity patterns seen in many other
published studies, while investigating technical bias by applying the same
techniques to simulated microbial communities of known composition. Special
thanks are given to J. Gregory Caporaso for providing the OTU-clustered data
files for inclusion in the \pkg{phyloseq} package, from which this data was
converted to \code{TreeSummarizedExperiment}.
}
\references{
Caporaso, J. G., et al. (2011).
Global patterns of 16S rRNA diversity at a depth of millions of sequences per sample.
PNAS, 108, 4516-4522. \url{https://doi.org/10.1073/pnas.1000080107}
}
\seealso{
\code{\link{mia-datasets}}
}
\author{
Caporaso, J. G., et al.
}
\keyword{datasets}
