% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mia.R
\docType{data}
\name{HintikkaXOData}
\alias{HintikkaXOData}
\title{HintikkaXOData}
\format{
A MultiAssayExperiment with 3 experiments (microbiota, metabolites and
biomarkers). rowData of the microbiota experiment contains taxonomic information
at Phylum, Class, Order, Family, Genus, Species and OTU levels. The metabolites
and biomarkers experiments contain 38 NMR metabolites and 39 biomarkers,
respectively. The colData includes:

\describe{
\item{Sample}{Sample ID (character)}
\item{Rat}{Rat ID (factor)}
\item{Site}{Site of measurement ("Cecum"); single value}
\item{Diet}{Diet group (factor; combination of the Fat and XOS fields)}
\item{Fat}{Fat in Diet (factor; Low/High)}
\item{XOS}{XOS Diet Supplement (numeric; 0/1)}
}
}
\usage{
data(HintikkaXOData)
}
\description{
HintikkaXO is a multiomics dataset from a rat experiment studying effect of
fat and prebiotics in diet. It contains high-throughput profiling data from
40 rat samples, including 39 biomarkers, 38 metabolites (NMR), and 12706 OTUs
from 318 species, measured from Cecum. This is diet comparison study with
High/Low fat diet and xylo-oligosaccaride supplementation. Column metadata is
common for all experiments (microbiota, metabolites, biomarkers) and is
described below.
}
\references{
Hintikka L et al. (2021): Xylo-oligosaccharides in prevention of hepatic
steatosis and adipose tissue inflammation: associating taxonomic and
metabolomic patterns in fecal microbiota with biclustering. International
Journal of Environmental Research and Public Health 18(8):4049.
\url{https://doi.org/10.3390/ijerph18084049}
}
\seealso{
\code{\link{mia-datasets}}
}
\author{
Hintikka L et al.
}
\keyword{datasets}
