% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mia.R
\docType{data}
\name{Tengeler2020}
\alias{Tengeler2020}
\title{Tengeler2020}
\format{
A TreeSummarizedExperiment with 151 features and 27 samples. The
rowData contains taxonomic information at Kingdom, Phylum, Class, Order,
Family and Genus level. The colData includes:

\describe{
\item{patient_status}{clinical status of the patient (ADHD or Control)}
\item{cohort}{cohort to which the patient belongs (Cohort_1, Cohort_2 and
Cohort_3)}
\item{patient_status_vs_cohort}{combination of patient_status and cohort}
\item{sample_name}{unique sample ID}
}
}
\usage{
data(Tengeler2020)
}
\description{
Tengeler2020 includes gut microbiota profiles of 27 persons with ADHD. A
standard bioinformatic and statistical analysis done to demonstrate that
altered microbial composition could be a driver of altered brain structure
and function and concomitant changes in the animals’ behavior. This was
investigated by colonizing young, male, germ-free C57BL/6JOlaHsd mice with
microbiota from individuals with and without ADHD.
}
\references{
Tengeler, A.C., Dam, S.A., Wiesmann, M. et al.
Gut microbiota from persons with attention-deficit/hyperactivity disorder affects the brain in mice.
Microbiome 8, 44 (2020). \url{https://doi.org/10.1186/s40168-020-00816-x}

Supplemental information includes Home-cage activity, methods, results and imaging parameters and publicly-accessible from:
\url{https://static-content.springer.com/esm/art\%3A10.1186\%2Fs40168-020-00816-x/MediaObjects/40168_2020_816_MOESM1_ESM.docx}
\url{https://static-content.springer.com/esm/art\%3A10.1186\%2Fs40168-020-00816-x/MediaObjects/40168_2020_816_MOESM2_ESM.docx}
\url{https://static-content.springer.com/esm/art\%3A10.1186\%2Fs40168-020-00816-x/MediaObjects/40168_2020_816_MOESM3_ESM.docx}
}
\seealso{
\code{\link{mia-datasets}}
}
\author{
A.C. Tengeler, et al.
}
\keyword{datasets}
