% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateDivergence.R
\name{addDivergence}
\alias{addDivergence}
\alias{addDivergence,SummarizedExperiment-method}
\title{Estimate divergence}
\usage{
addDivergence(
  x,
  assay.type = assay_name,
  assay_name = "counts",
  name = "divergence",
  reference = "median",
  FUN = vegan::vegdist,
  method = "bray",
  ...
)

\S4method{addDivergence}{SummarizedExperiment}(
  x,
  assay.type = assay_name,
  assay_name = "counts",
  name = "divergence",
  reference = "median",
  FUN = vegan::vegdist,
  method = "bray",
  ...
)
}
\arguments{
\item{x}{a \code{\link{SummarizedExperiment}} object.}

\item{assay.type}{the name of the assay used for calculation of the
sample-wise estimates.}

\item{assay_name}{a single \code{character} value for specifying which
assay to use for calculation.
(Please use \code{assay.type} instead. At some point \code{assay_name}
will be disabled.)}

\item{name}{a name for the column of the colData the results should be
stored in. By default, \code{name} is \code{"divergence"}.}

\item{reference}{a numeric vector that has length equal to number of
features, or a non-empty character value; either 'median' or 'mean'.
\code{reference} specifies the reference that is used to calculate
\code{divergence}. by default, \code{reference} is  \code{"median"}.}

\item{FUN}{a \code{function} for distance calculation. The function must
expect the input matrix as its first argument. With rows as samples
and columns as features. By default, \code{FUN} is
\code{vegan::vegdist}.}

\item{method}{a method that is used to calculate the distance. Method is
passed to the function that is specified by \code{FUN}. By default,
\code{method} is \code{"bray"}.}

\item{...}{optional arguments}
}
\value{
\code{x} with additional \code{\link{colData}} named \code{*name*}
}
\description{
Estimate divergence against a given reference sample.
}
\details{
Microbiota divergence (heterogeneity / spread) within a given sample
set can be quantified by the average sample dissimilarity or beta
diversity with respect to a given reference sample.

This measure is sensitive to sample size.
Subsampling or bootstrapping can be applied to equalize sample sizes
between comparisons.
}
\examples{
data(GlobalPatterns)
tse <- GlobalPatterns

# By default, reference is median of all samples. The name of column where results
# is "divergence" by default, but it can be specified. 
tse <- addDivergence(tse)

# The method that are used to calculate distance in divergence and 
# reference can be specified. Here, euclidean distance and dist function from 
# stats package are used. Reference is the first sample.
tse <- addDivergence(tse, name = "divergence_first_sample", 
                          reference = assays(tse)$counts[,1], 
                          FUN = stats::dist, method = "euclidean")

# Reference can also be median or mean of all samples. 
# By default, divergence is calculated by using median. Here, mean is used.
tse <- addDivergence(tse, name = "divergence_average", reference = "mean")

# All three divergence results are stored in colData.
colData(tse)

}
\seealso{
\code{\link[scater:plotColData]{plotColData}}
\itemize{
\item{\code{\link[mia:estimateRichness]{estimateRichness}}}
\item{\code{\link[mia:estimateEvenness]{estimateEvenness}}}
\item{\code{\link[mia:estimateDominance]{estimateDominance}}}
}
}
\author{
Leo Lahti and Tuomas Borman. Contact: \url{microbiome.github.io}
}
