% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateDMM.R
\name{calculateDMN}
\alias{calculateDMN}
\alias{calculateDMN,ANY-method}
\alias{calculateDMN,SummarizedExperiment-method}
\alias{runDMN}
\alias{getDMN}
\alias{getDMN,SummarizedExperiment-method}
\alias{bestDMNFit}
\alias{bestDMNFit,SummarizedExperiment-method}
\alias{getBestDMNFit}
\alias{getBestDMNFit,SummarizedExperiment-method}
\alias{calculateDMNgroup}
\alias{calculateDMNgroup,ANY-method}
\alias{calculateDMNgroup,SummarizedExperiment-method}
\alias{performDMNgroupCV}
\alias{performDMNgroupCV,ANY-method}
\alias{performDMNgroupCV,SummarizedExperiment-method}
\title{Dirichlet-Multinomial Mixture Model: Machine Learning for Microbiome Data}
\usage{
calculateDMN(x, ...)

\S4method{calculateDMN}{ANY}(
  x,
  k = 1,
  BPPARAM = SerialParam(),
  seed = runif(1, 0, .Machine$integer.max),
  ...
)

\S4method{calculateDMN}{SummarizedExperiment}(
  x,
  assay.type = assay_name,
  assay_name = exprs_values,
  exprs_values = "counts",
  transposed = FALSE,
  ...
)

runDMN(x, name = "DMN", ...)

getDMN(x, name = "DMN", ...)

\S4method{getDMN}{SummarizedExperiment}(x, name = "DMN")

bestDMNFit(x, name = "DMN", type = c("laplace", "AIC", "BIC"), ...)

\S4method{bestDMNFit}{SummarizedExperiment}(x, name = "DMN", type = c("laplace", "AIC", "BIC"))

getBestDMNFit(x, name = "DMN", type = c("laplace", "AIC", "BIC"), ...)

\S4method{getBestDMNFit}{SummarizedExperiment}(x, name = "DMN", type = c("laplace", "AIC", "BIC"))

calculateDMNgroup(x, ...)

\S4method{calculateDMNgroup}{ANY}(
  x,
  variable,
  k = 1,
  seed = runif(1, 0, .Machine$integer.max),
  ...
)

\S4method{calculateDMNgroup}{SummarizedExperiment}(
  x,
  variable,
  assay.type = assay_name,
  assay_name = exprs_values,
  exprs_values = "counts",
  transposed = FALSE,
  ...
)

performDMNgroupCV(x, ...)

\S4method{performDMNgroupCV}{ANY}(
  x,
  variable,
  k = 1,
  seed = runif(1, 0, .Machine$integer.max),
  ...
)

\S4method{performDMNgroupCV}{SummarizedExperiment}(
  x,
  variable,
  assay.type = assay_name,
  assay_name = exprs_values,
  exprs_values = "counts",
  transposed = FALSE,
  ...
)
}
\arguments{
\item{x}{a numeric matrix with samples as rows or a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object.}

\item{...}{optional arguments not used.}

\item{k}{the number of Dirichlet components to fit. See
\code{\link[DirichletMultinomial:dmn]{dmn}}}

\item{BPPARAM}{A
\code{\link[BiocParallel:BiocParallelParam-class]{BiocParallelParam}}
object specifying whether the UniFrac calculation should be parallelized.}

\item{seed}{random number seed. See
\code{\link[DirichletMultinomial:dmn]{dmn}}}

\item{assay.type}{a single \code{character} value for specifying which
assay to use for calculation.}

\item{assay_name}{a single \code{character} value for specifying which
assay to use for calculation.
(Please use \code{assay.type} instead. At some point \code{assay_name}
will be disabled.)}

\item{exprs_values}{a single \code{character} value for specifying which
assay to use for calculation.
(Please use \code{assay.type} instead.)}

\item{transposed}{Logical scalar, is x transposed with samples in rows?}

\item{name}{the name to store the result in
\code{\link[SummarizedExperiment:RangedSummarizedExperiment-class]{metadata}}}

\item{type}{the type of measure used for the goodness of fit. One of
\sQuote{laplace}, \sQuote{AIC} or \sQuote{BIC}.}

\item{variable}{a variable from \code{colData} to use as a grouping variable.
Must be a character of factor.}
}
\value{
\code{calculateDMN} and \code{getDMN} return a list of \code{DMN} objects,
one element for each value of k provided.

\code{bestDMNFit} returns the index for the best fit and \code{getBestDMNFit}
returns a single \code{DMN} object.

\code{calculateDMNgroup} returns a
\code{\link[DirichletMultinomial:DMNGroup-class]{DMNGroup}} object

\code{performDMNgroupCV} returns a \code{data.frame}
}
\description{
These functions are accessors for functions implemented in the
\code{\link[DirichletMultinomial:DirichletMultinomial-package]{DirichletMultinomial}}
package
}
\examples{
fl <- system.file(package="DirichletMultinomial", "extdata", "Twins.csv")
counts <- as.matrix(read.csv(fl, row.names=1))
fl <- system.file(package="DirichletMultinomial", "extdata", "TwinStudy.t")
pheno0 <- scan(fl)
lvls <- c("Lean", "Obese", "Overwt")
pheno <- factor(lvls[pheno0 + 1], levels=lvls)
colData <- DataFrame(pheno = pheno)

tse <- TreeSummarizedExperiment(assays = list(counts = counts),
                                colData = colData)

library(bluster)

# Compute DMM algorithm and store result in metadata
tse <- cluster(tse, name = "DMM", DmmParam(k = 1:3, type = "laplace"),
               MARGIN = "samples", full = TRUE)

# Get the list of DMN objects
metadata(tse)$DMM$dmm

# Get and display which objects fits best
bestFit <- metadata(tse)$DMM$best
bestFit

# Get the model that generated the best fit
bestModel <- metadata(tse)$DMM$dmm[[bestFit]]
bestModel

# Get the sample-cluster assignment probability matrix
head(metadata(tse)$DMM$prob)

# Get the weight of each component for the best model
bestModel@mixture$Weight
}
\seealso{
\code{\link[DirichletMultinomial:DMN-class]{DMN-class}},
\code{\link[DirichletMultinomial:DMNGroup-class]{DMNGroup-class}},
\code{\link[DirichletMultinomial:dmn]{dmn}},
\code{\link[DirichletMultinomial:dmngroup]{dmngroup}},
\code{\link[DirichletMultinomial:cvdmngroup]{cvdmngroup }},
\code{\link[DirichletMultinomial:fitted]{accessors for DMN objects}}
}
