% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateJSD.R
\name{calculateJSD}
\alias{calculateJSD}
\alias{calculateJSD,ANY-method}
\alias{calculateJSD,SummarizedExperiment-method}
\alias{runJSD}
\title{Calculate the Jensen-Shannon Divergence}
\usage{
\S4method{calculateJSD}{ANY}(x, ...)

\S4method{calculateJSD}{SummarizedExperiment}(
  x,
  assay.type = assay_name,
  assay_name = exprs_values,
  exprs_values = "counts",
  transposed = FALSE,
  ...
)

runJSD(x, BPPARAM = SerialParam(), chunkSize = nrow(x))
}
\arguments{
\item{x}{a numeric matrix or a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}.}

\item{...}{optional arguments not used.}

\item{assay.type}{a single \code{character} value for specifying which
assay to use for calculation.}

\item{assay_name}{a single \code{character} value for specifying which
assay to use for calculation.
(Please use \code{assay.type} instead. At some point \code{assay_name}
will be disabled.)}

\item{exprs_values}{a single \code{character} value for specifying which
assay to use for calculation.
(Please use \code{assay.type} instead.)}

\item{transposed}{Logical scalar, is x transposed with cells in rows?}

\item{BPPARAM}{A
\code{\link[BiocParallel:BiocParallelParam-class]{BiocParallelParam}}
object specifying whether the JSD calculation should be parallelized.}

\item{chunkSize}{an integer scalar, defining the size of data send
to the individual worker. Only has an effect, if \code{BPPARAM} defines
more than one worker. (default: \code{chunkSize = nrow(x)})}
}
\value{
a sample-by-sample distance matrix, suitable for NMDS, etc.
}
\description{
This function calculates the Jensen-Shannon Divergence (JSD) in a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object.
}
\examples{
data(enterotype)
library(scater)


jsd <- calculateJSD(enterotype)
class(jsd)
head(jsd)

enterotype <- runMDS(enterotype, FUN = calculateJSD, name = "JSD",
                     exprs_values = "counts")
head(reducedDim(enterotype))
head(attr(reducedDim(enterotype),"eig"))
attr(reducedDim(enterotype),"GOF")
}
\references{
Jensen-Shannon Divergence and Hilbert space embedding.
Bent Fuglede and Flemming Topsoe University of Copenhagen,
Department of Mathematics
\url{http://www.math.ku.dk/~topsoe/ISIT2004JSD.pdf}
}
\seealso{
\url{http://en.wikipedia.org/wiki/Jensen-Shannon_divergence}
}
\author{
Susan Holmes \email{susan@stat.stanford.edu}.
Adapted for phyloseq by Paul J. McMurdie.
Adapted for mia by Felix G.M. Ernst
}
