% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateOverlap.R
\name{calculateOverlap}
\alias{calculateOverlap}
\alias{calculateOverlap,SummarizedExperiment-method}
\alias{runOverlap}
\alias{runOverlap,SummarizedExperiment-method}
\title{Estimate overlap}
\usage{
calculateOverlap(
  x,
  assay.type = assay_name,
  assay_name = "counts",
  detection = 0,
  ...
)

\S4method{calculateOverlap}{SummarizedExperiment}(
  x,
  assay.type = assay_name,
  assay_name = "counts",
  detection = 0,
  ...
)

runOverlap(x, ...)

\S4method{runOverlap}{SummarizedExperiment}(x, name = "overlap", ...)
}
\arguments{
\item{x}{a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object containing a tree.}

\item{assay.type}{A single character value for selecting the
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{assay}}
to calculate the overlap.}

\item{assay_name}{a single \code{character} value for specifying which
assay to use for calculation.
(Please use \code{assay.type} instead. At some point \code{assay_name}
will be disabled.)}

\item{detection}{A single numeric value for selecting detection threshold for
absence/presence of features. Feature that has abundance under threshold in
either of samples, will be discarded when evaluating overlap between samples.}

\item{...}{Optional arguments not used.}

\item{name}{A single character value specifying the name of overlap matrix that
is stored in reducedDim(x).}
}
\value{
calculateOverlap returns sample-by-sample distance matrix.
runOverlap returns \code{x} that includes overlap matrix in its
reducedDim.
}
\description{
This function calculates overlap for all sample-pairs
in a \code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object.
}
\details{
These function calculates overlap between all the sample-pairs. Overlap
reflects similarity between sample-pairs.

When overlap is calculated using relative abundances, the higher the value the
higher the similarity is, When using relative abundances, overlap value 1 means that
all the abundances of features are equal between two samples, and 0 means that
samples have completely different relative abundances.
}
\examples{
data(esophagus)
tse <- esophagus
tse <- transformAssay(tse, method = "relabundance")
overlap <- calculateOverlap(tse, assay_name = "relabundance")
overlap

# Store result to reducedDim
tse <- runOverlap(tse, assay.type = "relabundance", name = "overlap_between_samples")
head(reducedDims(tse)$overlap_between_samples)

}
\seealso{
\code{\link[mia:calculateJSD]{calculateJSD}}
\code{\link[mia:calculateUnifrac]{calculateUnifrac}}
}
\author{
Leo Lahti and Tuomas Borman. Contact: \url{microbiome.github.io}
}
