% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importMetaphlan.R
\name{importMetaPhlAn}
\alias{importMetaPhlAn}
\title{Import Metaphlan results to \code{TreeSummarizedExperiment}}
\arguments{
\item{file}{a single \code{character} value defining the file
path of the Metaphlan file. The file must be in merged Metaphlan format.}

\item{colData}{a DataFrame-like object that includes sample names in
rownames, or a single \code{character} value defining the file
path of the sample metadata file. The file must be in \code{tsv} format
(default: \code{colData = NULL}).}

\item{sample_meta}{a DataFrame-like object that includes sample names in
rownames, or a single \code{character} value defining the file
path of the sample metadata file. The file must be in \code{tsv} format
(default: \code{sample_meta = NULL}).}

\item{phy_tree}{a single \code{character} value defining the file
path of the phylogenetic tree.
(default: \code{phy_tree = NULL}).}

\item{...}{additional arguments:
\itemize{
\item{\code{assay.type}:} {A single character value for naming
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{assay}}
(default: \code{assay.type = "counts"})}
\item{\code{assay_name}:} {A single \code{character} value for specifying which
assay to use for calculation. (Please use \code{assay.type} instead.
At some point \code{assay_name} will be disabled.)}
\item{\code{removeTaxaPrefixes}:} {\code{TRUE} or \code{FALSE}: Should
taxonomic prefixes be removed? (default:
\code{removeTaxaPrefixes = FALSE})}
\item{\code{remove.suffix}:} {\code{TRUE} or \code{FALSE}: Should
suffixes of sample names be removed? Metaphlan pipeline adds suffixes
to sample names. Suffixes are formed from file names. By selecting
\code{remove.suffix = TRUE}, you can remove pattern from end of sample
names that is shared by all. (default: \code{remove.suffix = FALSE})}
\item{\code{set.ranks}:} {\code{TRUE} or \code{FALSE}: Should the columns
in the rowData that are treated as taxonomy ranks be updated according to
the ranks found in the imported data?
(default: \code{set.ranks = FALSE})}
}}
}
\value{
A
\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-class]{TreeSummarizedExperiment}}
object
}
\description{
Import Metaphlan results to \code{TreeSummarizedExperiment}
}
\details{
Import Metaphlan (versions 2, 3 and 4 supported) results.
Input must be in merged Metaphlan format.
(See
\href{https://github.com/biobakery/MetaPhlAn/wiki/MetaPhlAn-4#merging-tables}{
the Metaphlan documentation and \code{merge_metaphlan_tables} method.})
Data is imported so that data at the lowest rank is imported as a
\code{TreeSummarizedExperiment} object. Data at higher rank is imported as a
\code{SummarizedExperiment} objects which are stored to \code{altExp} of
\code{TreeSummarizedExperiment} object.

Currently Metaphlan versions 2, 3, and 4 are supported.
}
\examples{
# (Data is from tutorial
# https://github.com/biobakery/biobakery/wiki/metaphlan3#merge-outputs)

# File path
file_path <- system.file("extdata", "merged_abundance_table.txt", package = "mia")
# Import data
tse <- importMetaPhlAn(file_path)
# Data at the lowest rank
tse
# Data at higher rank is stored in altExp
altExps(tse)
# Higher rank data is in SE format, for example, Phylum rank
altExp(tse, "Phylum")

}
\references{
Beghini F, McIver LJ, Blanco-Míguez A, Dubois L, Asnicar F, Maharjan S, Mailyan A,
Manghi P, Scholz M, Thomas AM, Valles-Colomer M, Weingart G, Zhang Y, Zolfo M,
Huttenhower C, Franzosa EA, & Segata N (2021) Integrating taxonomic, functional,
and strain-level profiling of diverse microbial communities with bioBakery 3.
\emph{eLife}. 10:e65088. doi: 10.7554/eLife.65088
}
\seealso{
\code{\link[=importHUMAnN]{importHUMAnN}}
\code{\link[=makeTreeSEFromPhyloseq]{makeTreeSEFromPhyloseq}}
\code{\link[=makeTreeSEFromBiom]{makeTreeSEFromBiom}}
\code{\link[=makeTreeSEFromDADA2]{makeTreeSEFromDADA2}}
\code{\link[=importQIIME2]{importQIIME2}}
\code{\link[=importMothur]{importMothur}}
}
\author{
Leo Lahti and Tuomas Borman. Contact: \url{microbiome.github.io}
}
