% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importMothur.R
\name{importMothur}
\alias{importMothur}
\title{Import Mothur results as a \code{TreeSummarizedExperiment}}
\usage{
importMothur(sharedFile, taxonomyFile = NULL, designFile = NULL)
}
\arguments{
\item{sharedFile}{a single \code{character} value defining the file
path of the feature table to be imported. The File has to be in
\code{shared file} format as defined in Mothur documentation.}

\item{taxonomyFile}{a single \code{character} value defining the file path of
the taxonomy table to be imported. The File has to be in \code{taxonomy
  file} or \code{constaxonomy file} format  as defined in Mothur
documentation. (default: \code{taxonomyFile = NULL}).}

\item{designFile}{a single \code{character} value defining the file path of
the sample metadata to be imported. The File has to be in \code{desing
  file} format as defined in Mothur documentation. (default: \code{designFile
  = NULL}).}
}
\value{
A
\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-class]{TreeSummarizedExperiment}}
object
}
\description{
This method creates a \code{TreeSummarizedExperiment} object from \code{Mothur}
files provided as input.
}
\details{
Results exported from Mothur can be imported as a
\code{SummarizedExperiment} using \code{importMothur}. Except for the
\code{sharedFile}, the other data types, \code{taxonomyFile}, and
\code{designFile}, are optional, but are highly encouraged to be provided.
}
\examples{
# Abundance table
counts <- system.file("extdata", "mothur_example.shared", package = "mia")
# Taxa table (in "cons.taxonomy" or "taxonomy" format)
taxa <- system.file("extdata", "mothur_example.cons.taxonomy", package = "mia")
#taxa <- system.file("extdata", "mothur_example.taxonomy", package = "mia")
# Sample meta data
meta <- system.file("extdata", "mothur_example.design", package = "mia")

# Creates se object from files
se <- importMothur(counts, taxa, meta)
# Convert SE to TreeSE
tse <- as(se, "TreeSummarizedExperiment")
tse
}
\references{
\url{https://mothur.org/}
\url{https://mothur.org/wiki/shared_file/}
\url{https://mothur.org/wiki/taxonomy_file/}
\url{https://mothur.org/wiki/constaxonomy_file/}
\url{https://mothur.org/wiki/design_file/}
}
\seealso{
\code{\link[=makeTreeSEFromPhyloseq]{makeTreeSEFromPhyloseq}}
\code{\link[=makeTreeSEFromBiom]{makeTreeSEFromBiom}}
\code{\link[=makeTreeSEFromDADA2]{makeTreeSEFromDADA2}}
\code{\link[=importQIIME2]{importQIIME2}}
}
\author{
Leo Lahti and Tuomas Borman. Contact: \url{microbiome.github.io}
}
