% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decontam.R
\name{isContaminant}
\alias{isContaminant}
\alias{isContaminant,SummarizedExperiment-method}
\alias{isNotContaminant,SummarizedExperiment-method}
\alias{addContaminantQC}
\alias{addContaminantQC,SummarizedExperiment-method}
\alias{addNotContaminantQC}
\alias{addNotContaminantQC,SummarizedExperiment-method}
\title{decontam functions}
\usage{
\S4method{isContaminant}{SummarizedExperiment}(
  seqtab,
  assay.type = assay_name,
  assay_name = "counts",
  name = "isContaminant",
  concentration = NULL,
  control = NULL,
  batch = NULL,
  threshold = 0.1,
  normalize = TRUE,
  detailed = TRUE,
  ...
)

\S4method{isNotContaminant}{SummarizedExperiment}(
  seqtab,
  assay.type = assay_name,
  assay_name = "counts",
  name = "isNotContaminant",
  control = NULL,
  threshold = 0.5,
  normalize = TRUE,
  detailed = FALSE,
  ...
)

addContaminantQC(x, name = "isContaminant", ...)

\S4method{addContaminantQC}{SummarizedExperiment}(x, name = "isContaminant", ...)

addNotContaminantQC(x, name = "isNotContaminant", ...)

\S4method{addNotContaminantQC}{SummarizedExperiment}(x, name = "isNotContaminant", ...)
}
\arguments{
\item{seqtab, x}{a \code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}}

\item{assay.type}{A single character value for selecting the
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{assay}}
to use.}

\item{assay_name}{a single \code{character} value for specifying which
assay to use for calculation.
(Please use \code{assay.type} instead. At some point \code{assay_name}
will be disabled.)}

\item{name}{A name for the column of the colData in which the contaminant
information should be stored.}

\item{concentration}{\code{NULL} or a single \code{character} value. Defining
a column with numeric values from the \code{colData} to use as
concentration information. (default: \code{concentration = NULL})}

\item{control}{\code{NULL} or a single \code{character} value. Defining a
column with logical values from the \code{colData} to define control and
non-control samples. (default: \code{control = NULL})}

\item{batch}{\code{NULL} or a single \code{character} value. Defining a
column with values interpretable as a factor from the \code{colData} to use
as batch information. (default: \code{batch = NULL})}

\item{threshold}{numeric scalar. See
\code{\link[decontam:isContaminant]{decontam:isContaminant}} or
\code{\link[decontam:isNotContaminant]{decontam:isNotContaminant}}}

\item{normalize, detailed}{logical scalar. See
\code{\link[decontam:isContaminant]{decontam:isContaminant}} or
\code{\link[decontam:isNotContaminant]{decontam:isNotContaminant}}}

\item{...}{\itemize{
\item{for \code{isContaminant}/ \code{isNotContaminant}: }{arguments
passed on to \code{\link[decontam:isContaminant]{decontam:isContaminant}}
or \code{\link[decontam:isNotContaminant]{decontam:isNotContaminant}}}
\item{for \code{addContaminantQC}/\code{addNotContaminantQC}: }{arguments
passed on to \code{isContaminant}/ \code{isNotContaminant}}
}}
}
\value{
for \code{isContaminant}/ \code{isNotContaminant} a \code{DataFrame}
or for \code{addContaminantQC}/\code{addNotContaminantQC} a modified object
of \code{class(x)}
}
\description{
The \code{decontam} functions \code{isContaminant} and
\code{isNotContaminant} are made available for
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
objects.
}
\examples{
data(esophagus)
# setup of some mock data
colData(esophagus)$concentration <- c(1,2,3)
colData(esophagus)$control <- c(FALSE,FALSE,TRUE)

isContaminant(esophagus,
              method = "frequency",
              concentration = "concentration")
esophagus <- addContaminantQC(esophagus,
                              method = "frequency",
                              concentration = "concentration")
colData(esophagus)

isNotContaminant(esophagus, control = "control")
esophagus <- addNotContaminantQC(esophagus, control = "control")
colData(esophagus)
}
\seealso{
\code{\link[decontam:isContaminant]{decontam:isContaminant}},
\code{\link[decontam:isNotContaminant]{decontam:isNotContaminant}}
}
