% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makephyloseqFromTreeSummarizedExperiment.R
\name{makePhyloseqFromTreeSE}
\alias{makePhyloseqFromTreeSE}
\alias{makePhyloseqFromTreeSE,SummarizedExperiment-method}
\alias{makePhyloseqFromTreeSE,TreeSummarizedExperiment-method}
\alias{makePhyloseqFromTreeSummarizedExperiment}
\alias{makePhyloseqFromTreeSummarizedExperiment,ANY-method}
\title{Create a phyloseq object from a TreeSummarizedExperiment object}
\usage{
makePhyloseqFromTreeSE(x, ...)

\S4method{makePhyloseqFromTreeSE}{SummarizedExperiment}(x, assay.type = "counts", assay_name = NULL, ...)

\S4method{makePhyloseqFromTreeSE}{TreeSummarizedExperiment}(x, tree_name = "phylo", ...)

makePhyloseqFromTreeSummarizedExperiment(x, ...)

\S4method{makePhyloseqFromTreeSummarizedExperiment}{ANY}(x, ...)
}
\arguments{
\item{x}{a \code{TreeSummarizedExperiment} object}

\item{...}{additional arguments}

\item{assay.type}{A single character value for selecting the
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{assay}} to be
included in the phyloseq object that is created.
(By default: \code{assay.type = "counts"})}

\item{assay_name}{a single \code{character} value for specifying which
assay to use for calculation.
(Please use \code{assay.type} instead. At some point \code{assay_name}
will be disabled.)}

\item{tree_name}{a single \code{character} value for specifying which
tree will be included in the phyloseq object that is created,
(By default: \code{tree_name = "phylo"})}
}
\value{
An object of class \code{Phyloseq} object.
}
\description{
This function creates a phyloseq object from a TreeSummarizedExperiment
object. By using \code{assay.type}, it is possible to specify which table
from \code{assay} is added to the phyloseq object.
}
\details{
\code{makePhyloseqFromTreeSE} is used for creating a
phyloseq object from TreeSummarizedExperiment object.
}
\examples{
# Get tse object
data(GlobalPatterns)
tse <- GlobalPatterns

# Create a phyloseq object from it
phy <- makePhyloseqFromTreeSE(tse)
phy

# By default the chosen table is counts, but if there are other tables,
# they can be chosen with assay.type.

# Counts relative abundances table
tse <- transformAssay(tse, method = "relabundance")
phy2 <- makePhyloseqFromTreeSE(tse, assay.type = "relabundance")
phy2
}
\author{
Leo Lahti and Tuomas Borman. Contact: \url{microbiome.github.io}
}
