% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeTreeSummarizedExperimentFromBiom.R
\name{makeTreeSEFromBiom}
\alias{makeTreeSEFromBiom}
\alias{importBIOM}
\alias{makeTreeSummarizedExperimentFromBiom}
\title{Loading a biom file}
\usage{
importBIOM(file, ...)

makeTreeSEFromBiom(
  obj,
  removeTaxaPrefixes = FALSE,
  rankFromPrefix = FALSE,
  remove.artifacts = FALSE,
  ...
)

makeTreeSummarizedExperimentFromBiom(obj, ...)
}
\arguments{
\item{file}{biom file location}

\item{...}{additional arguments
\itemize{
\item{\code{patter}}{\code{character} value specifying artifacts
to be removed. If \code{patterns = "auto"}, special characters
are removed. (default: \code{pattern = "auto"})}
}}

\item{obj}{object of type \code{\link[biomformat:read_biom]{biom}}}

\item{removeTaxaPrefixes}{\code{TRUE} or \code{FALSE}: Should
taxonomic prefixes be removed? The prefixes is removed only from detected
taxa columns meaning that \code{rankFromPrefix} should be enabled in the most cases.
(default \code{removeTaxaPrefixes = FALSE})}

\item{rankFromPrefix}{\code{TRUE} or \code{FALSE}: If file does not have
taxonomic ranks on feature table, should they be scraped from prefixes?
(default \code{rankFromPrefix = FALSE})}

\item{remove.artifacts}{\code{TRUE} or \code{FALSE}: If file have
some taxonomic character naming artifacts, should they be removed.
(default \code{remove.artifacts = FALSE})}
}
\value{
An object of class
\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-class]{TreeSummarizedExperiment}}
}
\description{
For convenience a few functions are available to convert data from a
\sQuote{biom} file or object into a
\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-class]{TreeSummarizedExperiment}}
}
\examples{
# Load biom file
library(biomformat)
biom_file <- system.file("extdata", "rich_dense_otu_table.biom",
                         package = "biomformat")

# Make TreeSE from biom file
tse <- importBIOM(biom_file)

# Make TreeSE from biom object
biom_object <- biomformat::read_biom(biom_file)
tse <- makeTreeSEFromBiom(biom_object)

# Get taxonomyRanks from prefixes and remove prefixes
tse <- importBIOM(biom_file,
                    rankFromPrefix = TRUE,
                    removeTaxaPrefixes = TRUE)

# Load another biom file
biom_file <- system.file("extdata/testdata", "Aggregated_humanization2.biom",
                         package = "mia")

# Clean artifacts from taxonomic data
tse <- importBIOM(biom_file,
                    remove.artifacts = TRUE)
}
\seealso{
\code{\link[=makeTreeSEFromPhyloseq]{makeTreeSEFromPhyloseq}}
\code{\link[=makeTreeSEFromDADA2]{makeTreeSEFromDADA2}}
\code{\link[=importQIIME2]{importQIIME2}}
\code{\link[=importMothur]{importMothur}}
}
