% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeTreeSummarizedExperimentFromDADA2.R
\name{makeTreeSEFromDADA2}
\alias{makeTreeSEFromDADA2}
\alias{makeTreeSummarizedExperimentFromDADA2}
\title{Coerce \sQuote{DADA2} results to \code{TreeSummarizedExperiment}}
\usage{
makeTreeSEFromDADA2(...)

makeTreeSummarizedExperimentFromDADA2(...)
}
\arguments{
\item{...}{See \code{mergePairs} function for
more details.}
}
\value{
An object of class \code{TreeSummarizedExperiment}
}
\description{
\code{makeTreeSEFromDADA2} is a wrapper for the
\code{mergePairs} function from the \code{dada2} package.
}
\details{
A count matrix is constructed via \code{makeSequenceTable(mergePairs(...))}
and rownames are dynamically created as \code{ASV(N)} with \code{N} from
1 to \code{nrow} of the count tables. The colnames and rownames from the
output of \code{makeSequenceTable} are stored as \code{colnames} and in the
\code{referenceSeq} slot of the \code{TreeSummarizedExperiment},
respectively.
}
\examples{
if(requireNamespace("dada2")) {
  fnF <- system.file("extdata", "sam1F.fastq.gz", package="dada2")
  fnR = system.file("extdata", "sam1R.fastq.gz", package="dada2")
  dadaF <- dada2::dada(fnF, selfConsist=TRUE)
  dadaR <- dada2::dada(fnR, selfConsist=TRUE)

  tse <- makeTreeSEFromDADA2(dadaF, fnF, dadaR, fnR)
  tse
}
}
\seealso{
\code{\link[=makeTreeSEFromPhyloseq]{makeTreeSEFromPhyloseq}}
\code{\link[=makeTreeSEFromBiom]{makeTreeSEFromBiom}}
\code{\link[=importQIIME2]{importQIIME2}}
\code{\link[=importMothur]{importMothur}}
}
