% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meltAssay.R
\name{meltAssay}
\alias{meltAssay}
\alias{meltAssay,SummarizedExperiment-method}
\title{Converting a \code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object into a long data.frame}
\usage{
meltAssay(
  x,
  assay.type = assay_name,
  assay_name = "counts",
  add_row_data = NULL,
  add_col_data = NULL,
  feature_name = "FeatureID",
  sample_name = "SampleID",
  ...
)

\S4method{meltAssay}{SummarizedExperiment}(
  x,
  assay.type = assay_name,
  assay_name = "counts",
  add_row_data = NULL,
  add_col_data = NULL,
  feature_name = "FeatureID",
  sample_name = "SampleID",
  ...
)
}
\arguments{
\item{x}{A numeric matrix or a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}}

\item{assay.type}{a \code{character} value to select an
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{assayNames}}}

\item{assay_name}{a single \code{character} value for specifying which
assay to use for calculation.
(Please use \code{assay.type} instead. At some point \code{assay_name}
will be disabled.)}

\item{add_row_data}{\code{NULL}, \code{TRUE} or a \code{character} vector to
select information from the \code{rowData} to add to the molten assay data.
If \code{add_row_data = NULL} no data will be added, if
\code{add_row_data = TRUE} all data will be added and if
\code{add_row_data} is a \code{character} vector, it will be used to subset
to given column names in \code{rowData}. (default:
\code{add_row_data = NULL})}

\item{add_col_data}{\code{NULL}, \code{TRUE} or a \code{character} vector to
select information from the \code{colData} to add to the molten assay data.
If \code{add_col_data = NULL} no data will be added, if
\code{add_col_data = TRUE} all data will be added and if
\code{add_col_data} is a \code{character} vector, it will be used to subset
to given column names in \code{colData}. (default:
\code{add_col_data = NULL})}

\item{feature_name}{a \code{character} scalar to use as the output's name
for the feature identifier. (default: \code{feature_name = "FeatureID"})}

\item{sample_name}{a \code{character} scalar to use as the output's name
for the sample identifier. (default: \code{sample_name = "SampleID"})}

\item{...}{optional arguments:
\itemize{
\item{check_names}{ A boolean value passed to data.frame function's check.name
argument. Determines if sample names are checked that they are syntactically
valid variable names and are not duplicated. If they are not, sample names
are modified. (default: \code{check_names = TRUE})}
}}
}
\value{
A \code{tibble} with the molten data. The assay values are given in a
column named like the selected assay \code{assay.type}. In addition, a
column \dQuote{FeatureID} will contain the rownames, if set, and analogously
a column \dQuote{SampleID} with the colnames, if set
}
\description{
\code{meltAssay} Converts a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}} object into a
long data.frame which can be used for \code{tidyverse}-tools.
}
\details{
If the \code{colData} contains a column \dQuote{SampleID} or the
\code{rowData} contains a column \dQuote{FeatureID}, they will be renamed to
\dQuote{SampleID_col} and \dQuote{FeatureID_row}, if row names or column
names are set.
}
\examples{
data(GlobalPatterns)
molten_tse <- meltAssay(GlobalPatterns,
                        assay.type = "counts",
                        add_row_data = TRUE,
                        add_col_data = TRUE
                        )
molten_tse
}
\author{
Sudarshan A. Shetty
}
