% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.R
\name{merge-methods}
\alias{merge-methods}
\alias{mergeRows}
\alias{mergeCols}
\alias{mergeFeatures}
\alias{mergeSamples}
\alias{mergeRows,SummarizedExperiment-method}
\alias{mergeCols,SummarizedExperiment-method}
\alias{mergeSmaples}
\alias{mergeFeatures,SummarizedExperiment-method}
\alias{mergeSamples,SummarizedExperiment-method}
\alias{mergeRows,TreeSummarizedExperiment-method}
\alias{mergeCols,TreeSummarizedExperiment-method}
\alias{mergeFeatures,TreeSummarizedExperiment-method}
\alias{mergeSamples,TreeSummarizedExperiment-method}
\title{Merge a subset of the rows or columns of a \code{SummarizedExperiment}}
\usage{
mergeRows(x, f, archetype = 1L, ...)

mergeCols(x, f, archetype = 1L, ...)

mergeFeatures(x, f, archetype = 1L, ...)

mergeSamples(x, f, archetype = 1L, ...)

\S4method{mergeRows}{SummarizedExperiment}(x, f, archetype = 1L, ...)

\S4method{mergeCols}{SummarizedExperiment}(x, f, archetype = 1L, ...)

\S4method{mergeFeatures}{SummarizedExperiment}(x, f, archetype = 1L, ...)

\S4method{mergeSamples}{SummarizedExperiment}(x, f, archetype = 1L, ...)

\S4method{mergeRows}{TreeSummarizedExperiment}(x, f, archetype = 1L, mergeTree = FALSE, mergeRefSeq = FALSE, ...)

\S4method{mergeCols}{TreeSummarizedExperiment}(x, f, archetype = 1L, mergeTree = FALSE, ...)

\S4method{mergeFeatures}{TreeSummarizedExperiment}(
  x,
  f,
  archetype = 1L,
  mergeTree = FALSE,
  mergeRefSeq = FALSE,
  ...
)

\S4method{mergeSamples}{TreeSummarizedExperiment}(x, f, archetype = 1L, mergeTree = FALSE, ...)
}
\arguments{
\item{x}{a \code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}} or
a \code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-class]{TreeSummarizedExperiment}}}

\item{f}{A factor for merging. Must be the same length as
\code{nrow(x)/ncol(x)}. Rows/Cols corresponding to the same level will be
merged. If \code{length(levels(f)) == nrow(x)/ncol(x)}, \code{x} will be
returned unchanged.}

\item{archetype}{Of each level of \code{f}, which element should be regarded
as the archetype and metadata in the columns or rows kept, while merging?
This can be single integer value or an integer vector of the same length
as \code{levels(f)}. (Default: \code{archetype = 1L}, which means the first
element encountered per factor level will be kept)}

\item{...}{Optional arguments:
\itemize{
\item{Passed on to \code{\link[scuttle:sumCountsAcrossFeatures]{sumCountsAcrossFeatures}},
with the exception of \code{subset_row}, \code{subset_col}}
}}

\item{mergeTree}{\code{TRUE} or \code{FALSE}: Should
\code{rowTree()} also be merged? (Default: \code{mergeTree = FALSE})}

\item{mergeRefSeq}{\code{TRUE} or \code{FALSE}: Should a consensus sequence
be calculated? If set to \code{FALSE}, the result from \code{archetype} is
returned; If set to \code{TRUE} the result from
\code{\link[DECIPHER:ConsensusSequence]{DECIPHER::ConsensusSequence}} is
returned. (Default: \code{mergeRefSeq = FALSE})}
}
\value{
An object of the same class as \code{x} with the specified entries
merged into one entry in all relevant components.
}
\description{
\code{mergeRows}/\code{mergeCols} merge data on rows or columns of a
\code{SummarizedExperiment} as defined by a \code{factor} alongside the
chosen dimension. Metadata from the \code{rowData} or \code{colData} are
retained as defined by \code{archetype}.
}
\details{
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{assay}} are
agglomerated, i.e. summed up. If the assay contains values other than counts
or absolute values, this can lead to meaningless values being produced.

These functions are similar to
\code{\link[scuttle:sumCountsAcrossFeatures]{sumCountsAcrossFeatures}}.
However, additional support for \code{TreeSummarizedExperiment} was added and
science field agnostic names were used. In addition the \code{archetype}
argument lets the user select how to preserve row or column data.

For merge data of assays the function from \code{scuttle} are used.
}
\examples{
data(esophagus)
esophagus
plot(rowTree(esophagus))
# get a factor for merging
f <- factor(regmatches(rownames(esophagus),
                       regexpr("^[0-9]*_[0-9]*",rownames(esophagus))))
merged <- mergeRows(esophagus,f, mergeTree = TRUE)
plot(rowTree(merged))
#
data(GlobalPatterns)
GlobalPatterns
merged <- mergeCols(GlobalPatterns,colData(GlobalPatterns)$SampleType)
merged
}
\seealso{
\code{\link[scuttle:sumCountsAcrossFeatures]{sumCountsAcrossFeatures}}
}
