% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeSEs.R
\name{mergeSEs}
\alias{mergeSEs}
\alias{mergeSEs,SimpleList-method}
\alias{mergeSEs,SummarizedExperiment-method}
\alias{mergeSEs,list-method}
\title{Merge SE objects into single SE object.}
\usage{
mergeSEs(x, ...)

\S4method{mergeSEs}{SimpleList}(
  x,
  assay.type = "counts",
  assay_name = NULL,
  join = "full",
  missing_values = NA,
  collapse_samples = FALSE,
  collapse_features = TRUE,
  verbose = TRUE,
  ...
)

\S4method{mergeSEs}{SummarizedExperiment}(x, y = NULL, ...)

\S4method{mergeSEs}{list}(x, ...)
}
\arguments{
\item{x}{a \code{\link{SummarizedExperiment}} object or a list of
\code{\link{SummarizedExperiment}} objects.}

\item{...}{optional arguments (not used).}

\item{assay.type}{A character value for selecting the
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{assay}}
to be merged. (By default: \code{assay.type = "counts"})}

\item{assay_name}{(Deprecated) alias for \code{assay.type}.}

\item{join}{A single character value for selecting the joining method.
Must be 'full', 'inner', 'left', or 'right'. 'left' and 'right' are disabled
when more than two objects are being merged.  (By default: \code{join = "full"})}

\item{missing_values}{NA, 0, or a single character values specifying the notation
of missing values. (By default: \code{missing_values = NA})}

\item{collapse_samples}{A boolean value for selecting whether to collapse identically
named samples to one. (By default: \code{collapse_samples = FALSE})}

\item{collapse_features}{A boolean value for selecting whether to collapse identically
named features to one. Since all taxonomy information is taken into account,
this concerns rownames-level (usually strain level) comparison. Often
OTU or ASV level is just an arbitrary number series from sequencing machine
meaning that the OTU information is not comparable between studies. With this
option, it is possible to specify whether these strains are combined if their
taxonomy information along with OTU number matches.
(By default: \code{collapse_features = TRUE})}

\item{verbose}{A single boolean value to choose whether to show messages.
(By default: \code{verbose = TRUE})}

\item{y}{a \code{\link{SummarizedExperiment}} object when \code{x} is a
\code{\link{SummarizedExperiment}} object. Disabled when \code{x} is a list.}
}
\value{
A single \code{SummarizedExperiment} object.
}
\description{
Merge SE objects into single SE object.
}
\details{
This function merges multiple \code{SummarizedExperiment} objects. It combines
\code{rowData}, \code{assays}, and \code{colData} so that the output includes
each unique row and column ones. The merging is done based on \code{rownames} and
\code{colnames}. \code{rowTree} and \code{colTree} are preserved if linkage
between rows/cols and the tree is found.

Equally named rows are interpreted as equal. Further
matching based on \code{rowData} is not done. For samples, collapsing
is disabled by default meaning that equally named samples that are stored
in different objects are interpreted as unique. Collapsing can be enabled
with \code{collapse_samples = TRUE} when equally named samples describe the same
sample.

If, for example, all rows are not shared with
individual objects, there are missing values in \code{assays}. The notation of missing
can be specified with the \code{missing_values} argument. If input consists of
\code{TreeSummarizedExperiment} objects, also \code{rowTree}, \code{colTree}, and
\code{referenceSeq} are preserved if possible. The data is preserved if
all the rows or columns can be found from it.

Compared to \code{cbind} and \code{rbind} \code{mergeSEs}
allows more freely merging since \code{cbind} and \code{rbind} expect
that rows and columns are matching, respectively.

You can choose joining methods from \code{'full'}, \code{'inner'},
\code{'left'}, and  \code{'right'}. In all the methods, all the samples are
included in the result object. However, with different methods, it is possible
to choose which rows are included.

\itemize{
\item{\code{full} -- all unique features}
\item{\code{inner} -- all shared features}
\item{\code{left} -- all the features of the first object}
\item{\code{right} -- all the features of the second object}
}

The output depends on the input. If the input contains \code{SummarizedExperiment}
object, then the output will be \code{SummarizedExperiment}. When all the input
objects belong to \code{TreeSummarizedExperiment}, the output will be
\code{TreeSummarizedExperiment}.
}
\examples{
data(GlobalPatterns)
data(esophagus)
data(enterotype)

# Take only subsets so that it wont take so long
tse1 <- GlobalPatterns[1:100, ]
tse2 <- esophagus
tse3 <- enterotype[1:100, ]

# Merge two TreeSEs
tse <- mergeSEs(tse1, tse2)

# Merge a list of TreeSEs
list <- SimpleList(tse1, tse2, tse3)
tse <- mergeSEs(list, assay.type = "counts", missing_values = 0)
tse

# With 'join', it is possible to specify the merging method. Subsets are used
# here just to show the functionality
tse_temp <- mergeSEs(tse[1:10, 1:10], tse[5:100, 11:20], join = "left")
tse_temp

# If your objects contain samples that describe one and same sample,
# you can collapse equally named samples to one by specifying 'collapse_samples'
tse_temp <- mergeSEs(list(tse[1:10, 1], tse[1:20, 1], tse[1:5, 1]), 
                       collapse_samples = TRUE,
                       join = "inner")
tse_temp

# Merge all available assays
tse <- transformAssay(tse, method="relabundance")
ts1 <- transformAssay(tse1, method="relabundance")
tse_temp <- mergeSEs(tse, tse1, assay.type = assayNames(tse))

}
\seealso{
\itemize{
\item{\code{TreeSummarizedExperiment::cbind}}
\item{\code{TreeSummarizedExperiment::rbind}}
\item{\code{\link[dplyr:full_join]{full_join}}}
\item{\code{\link[dplyr:inner_join]{inner_join}}}
\item{\code{\link[dplyr:left_join]{left_join}}}
\item{\code{\link[dplyr:right_join]{right_join}}}
}
}
\author{
Leo Lahti and Tuomas Borman. Contact: \url{microbiome.github.io}
}
