% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dominantTaxa.R
\name{perSampleDominantTaxa}
\alias{perSampleDominantTaxa}
\alias{perSampleDominantFeatures}
\alias{perSampleDominantFeatures,SummarizedExperiment-method}
\alias{perSampleDominantTaxa,SummarizedExperiment-method}
\alias{addPerSampleDominantFeatures}
\alias{addPerSampleDominantTaxa}
\alias{addPerSampleDominantFeatures,SummarizedExperiment-method}
\alias{addPerSampleDominantTaxa,SummarizedExperiment-method}
\title{Get dominant taxa}
\usage{
perSampleDominantFeatures(
  x,
  assay.type = assay_name,
  assay_name = "counts",
  rank = NULL,
  other.name = "Other",
  n = NULL,
  complete = TRUE,
  ...
)

\S4method{perSampleDominantFeatures}{SummarizedExperiment}(
  x,
  assay.type = assay_name,
  assay_name = "counts",
  rank = NULL,
  other.name = "Other",
  n = NULL,
  complete = TRUE,
  ...
)

perSampleDominantTaxa(x, ...)

\S4method{perSampleDominantTaxa}{SummarizedExperiment}(x, ...)

addPerSampleDominantFeatures(
  x,
  name = "dominant_taxa",
  other.name = "Other",
  n = NULL,
  ...
)

\S4method{addPerSampleDominantFeatures}{SummarizedExperiment}(
  x,
  name = "dominant_taxa",
  other.name = "Other",
  n = NULL,
  complete = FALSE,
  ...
)

addPerSampleDominantTaxa(x, ...)

\S4method{addPerSampleDominantTaxa}{SummarizedExperiment}(x, ...)
}
\arguments{
\item{x}{A
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object.}

\item{assay.type}{A single character value for selecting the
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{assay}}
to use for identifying dominant taxa.}

\item{assay_name}{a single \code{character} value for specifying which
assay to use for calculation.
(Please use \code{assay.type} instead. At some point \code{assay_name}
will be disabled.)}

\item{rank}{A single character defining a taxonomic rank. Must be a value of
the output of \code{taxonomyRanks()}.}

\item{other.name}{A name for features that are not included in n the most frequent
dominant features in the data. Default is "Other".}

\item{n}{The number of features that are the most frequent dominant features.
Default is NULL, which defaults that each sample is assigned a dominant taxon.}

\item{complete}{A boolean value to manage multiple dominant taxa for a sample.
Default for perSampleDominantTaxa is TRUE to include all equally dominant taxa
for each sample. complete = FALSE samples one taxa for the samples that have
multiple.
Default for addPerSampleDominantTaxa is FALSE to add a column with only one
dominant taxon assigned for each sample into colData. complete = TRUE adds a
list that includes all dominant taxa for each sample into colData.}

\item{...}{Additional arguments passed on to \code{agglomerateByRank()} when
\code{rank} is specified.}

\item{name}{A name for the column of the \code{colData} where the dominant
taxa will be stored in when using \code{addPerSampleDominantFeatures}.}
}
\value{
\code{perSampleDominantFeatures} returns a named character vector \code{x}
while \code{addPerSampleDominantFeatures} returns
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
with additional column in \code{\link{colData}} named \code{*name*}.
}
\description{
These functions return information about the most dominant taxa in a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object.
}
\details{
\code{addPerSampleDominantFeatures} extracts the most abundant taxa in a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object, and stores the information in the \code{colData}. It is a wrapper for
\code{perSampleDominantFeatures}.

With \code{rank} parameter, it is possible to agglomerate taxa based on taxonomic
ranks. E.g. if 'Genus' rank is used, all abundances of same Genus are added
together, and those families are returned. See \code{agglomerateByRank()} for
additional arguments to deal with missing values or special characters.
}
\examples{
data(GlobalPatterns)
x <- GlobalPatterns

# Finds the dominant taxa.
sim.dom <- perSampleDominantFeatures(x, rank="Genus")

# Add information to colData
x <- addPerSampleDominantFeatures(x, rank = "Genus", name="dominant_genera")
colData(x)
}
\author{
Leo Lahti, Tuomas Borman and Sudarshan A. Shetty.
}
